/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython.factories;

import com.google.common.base.Preconditions;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.factories.ComputationFactory;
import org.apache.giraph.graph.Computation;
import org.apache.giraph.jython.JythonComputation;
import org.apache.giraph.jython.JythonGiraphComputation;
import org.apache.giraph.jython.JythonOptions;
import org.apache.giraph.jython.JythonUtils;
import org.apache.giraph.scripting.ScriptLoader;
import org.apache.log4j.Logger;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonComputationFactory
implements ComputationFactory {
    private static volatile PyObject JYTHON_COMPUTATION_MODULE;
    private static final Logger LOG;

    private static void setPythonComputationModule(PyObject mod) {
        JYTHON_COMPUTATION_MODULE = mod;
    }

    private static PyObject getPythonComputationModule() {
        return JYTHON_COMPUTATION_MODULE;
    }

    public void initialize(ImmutableClassesGiraphConfiguration conf) {
        PythonInterpreter interpreter = JythonUtils.getInterpreter();
        String className = this.computationName(conf);
        PyObject pyComputationModule = interpreter.get(className);
        Preconditions.checkNotNull((Object)pyComputationModule, (Object)("Could not find Jython Computation class " + className + " in loaded scripts: " + ScriptLoader.getLoadedScripts()));
        JythonComputationFactory.setPythonComputationModule(pyComputationModule);
    }

    public Computation createComputation(ImmutableClassesGiraphConfiguration conf) {
        Preconditions.checkNotNull((Object)JYTHON_COMPUTATION_MODULE, (Object)("Jython Computation class not set in loaded scripts: " + ScriptLoader.getLoadedScripts()));
        PyObject pyComputationObj = JYTHON_COMPUTATION_MODULE.__call__();
        Object computeObj = pyComputationObj.__tojava__(JythonComputation.class);
        if (!(computeObj instanceof JythonComputation)) {
            throw new IllegalStateException("getComputation: Jython object " + this.computationName(conf) + " is not a JythonComputation");
        }
        JythonComputation jythonCompute = (JythonComputation)computeObj;
        conf.configureIfPossible(jythonCompute);
        JythonGiraphComputation giraphCompute = new JythonGiraphComputation(jythonCompute);
        giraphCompute.setConf(conf);
        jythonCompute.setGiraphCompute(giraphCompute);
        return giraphCompute;
    }

    public void checkConfiguration(ImmutableClassesGiraphConfiguration conf) {
        if (ScriptLoader.SCRIPTS_TO_LOAD.isDefaultValue(conf)) {
            throw new IllegalStateException("checkConfiguration: " + ScriptLoader.SCRIPTS_TO_LOAD.getKey() + " not set in configuration");
        }
        if (!JythonOptions.JYTHON_COMPUTATION_CLASS_NAME.contains(conf)) {
            throw new IllegalStateException("checkConfiguration: " + JythonOptions.JYTHON_COMPUTATION_CLASS_NAME.getKey() + " not set in configuration");
        }
    }

    @Override
    public String computationName(GiraphConfiguration conf) {
        return JythonOptions.JYTHON_COMPUTATION_CLASS_NAME.get(conf);
    }

    static {
        LOG = Logger.getLogger(JythonUtils.class);
    }
}

