/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.graph.Language;
import org.apache.giraph.jython.JythonOptions;
import org.apache.giraph.jython.factories.JythonComputationFactory;
import org.apache.hadoop.conf.Configuration;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.util.PythonInterpreter;

public class JythonUtils {
    private static final PythonInterpreter INTERPRETER = new PythonInterpreter();

    private JythonUtils() {
    }

    public static PythonInterpreter getInterpreter() {
        return INTERPRETER;
    }

    public static void init(Configuration conf, String klassName) {
        GiraphConstants.COMPUTATION_LANGUAGE.set(conf, Language.JYTHON);
        GiraphConstants.COMPUTATION_FACTORY_CLASS.set(conf, JythonComputationFactory.class);
        JythonOptions.JYTHON_COMPUTATION_CLASS_NAME.set(conf, klassName);
    }

    public static PyObject newInstance(String className) {
        PyObject pyClass = JythonUtils.getInterpreter().get(className);
        PyObject pyObject = pyClass.__call__();
        return pyObject;
    }

    public static <T> T newInstance(String className, Class<? extends T> klass) {
        PyObject pyObject = JythonUtils.newInstance(className);
        Object object = pyObject.__tojava__(klass);
        if (Py.NoConversion.equals(object)) {
            throw new IllegalArgumentException("Cannot coerce Jython class " + className + " to Java type " + klass.getSimpleName());
        }
        return (T)object;
    }
}

