/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import org.apache.giraph.conf.BooleanConfOption;
import org.apache.giraph.conf.EnumConfOption;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.graph.Language;

public class JythonOptions {
    public static final JythonGraphTypeOptions JYTHON_VERTEX_ID = new JythonGraphTypeOptions(GraphType.VERTEX_ID);
    public static final JythonGraphTypeOptions JYTHON_VERTEX_VALUE = new JythonGraphTypeOptions(GraphType.VERTEX_VALUE);
    public static final JythonGraphTypeOptions JYTHON_EDGE_VALUE = new JythonGraphTypeOptions(GraphType.EDGE_VALUE);
    public static final JythonGraphTypeOptions JYTHON_IN_MSG_VALUE = new JythonGraphTypeOptions(GraphType.INCOMING_MESSAGE_VALUE);
    public static final JythonGraphTypeOptions JYTHON_OUT_MSG_VALUE = new JythonGraphTypeOptions(GraphType.OUTGOING_MESSAGE_VALUE);
    public static final StrConfOption JYTHON_COMPUTATION_CLASS_NAME = new StrConfOption("giraph.jython.class", null, "Name of Computation class in Jython script");

    private JythonOptions() {
    }

    public static class JythonGraphTypeOptions {
        private final GraphType graphType;
        private final StrConfOption jythonClassNameOption;
        private final BooleanConfOption needsWrapperOption;
        private final EnumConfOption<Language> languageOption;

        public JythonGraphTypeOptions(GraphType graphType) {
            this.graphType = graphType;
            this.jythonClassNameOption = new StrConfOption("giraph.jython." + graphType.dotString() + ".class.name", null, "Name of class in Jython implementing " + graphType.spaceString());
            this.needsWrapperOption = new BooleanConfOption("giraph.jython." + graphType.dotString() + ".needs.wrapper", false, "Whether the " + graphType.spaceString() + " jython type needs a wrapper");
            this.languageOption = EnumConfOption.create("giraph." + graphType.dotString() + ".language", Language.class, Language.JAVA, "Language " + graphType.spaceString() + " is implemented in");
        }

        public GraphType getGraphType() {
            return this.graphType;
        }

        public BooleanConfOption getNeedsWrapperOption() {
            return this.needsWrapperOption;
        }

        public StrConfOption getJythonClassNameOption() {
            return this.jythonClassNameOption;
        }

        private EnumConfOption<Language> getLanguageOption() {
            return this.languageOption;
        }
    }
}

