/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.giraph.combiner.MessageCombiner;

public class JythonJob {
    private String name;
    private String hive_database = "digraph";
    private int workers = 5;
    private String pool;
    private final TypeWithHive vertex_id = new TypeWithHive();
    private final TypeWithHive vertex_value = new TypeWithHive();
    private final TypeWithHive edge_value = new TypeWithHive();
    private final TypeHolder incoming_message_value = new TypeHolder();
    private final TypeHolder outgoing_message_value = new TypeHolder();
    private final TypeHolder message_value = new TypeHolder();
    private String computation_name;
    private Class<? extends MessageCombiner> messageCombiner;
    private final List<String> java_options = Lists.newArrayList();
    private final Map<String, Object> giraph_options = Maps.newHashMap();
    private final List<VertexInput> vertex_inputs = Lists.newArrayList();
    private final List<EdgeInput> edge_inputs = Lists.newArrayList();
    private final VertexOutput vertex_output = new VertexOutput();
    private String user = System.getProperty("user.name");

    public String getUser() {
        return this.user;
    }

    public TypeWithHive getVertex_value() {
        return this.vertex_value;
    }

    public TypeWithHive getVertex_id() {
        return this.vertex_id;
    }

    public TypeWithHive getEdge_value() {
        return this.edge_value;
    }

    public TypeHolder getIncoming_message_value() {
        return this.incoming_message_value;
    }

    public TypeHolder getOutgoing_message_value() {
        return this.outgoing_message_value;
    }

    public TypeHolder getMessage_value() {
        return this.message_value;
    }

    public List<String> getJava_options() {
        return this.java_options;
    }

    public Map<String, Object> getGiraph_options() {
        return this.giraph_options;
    }

    public Class<? extends MessageCombiner> getMessageCombiner() {
        return this.messageCombiner;
    }

    public void setMessageCombiner(Class<? extends MessageCombiner> messageCombiner) {
        this.messageCombiner = messageCombiner;
    }

    public String getComputation_name() {
        return this.computation_name;
    }

    public void setComputation_name(String computation_name) {
        this.computation_name = computation_name;
    }

    public String getHive_database() {
        return this.hive_database;
    }

    public void setHive_database(String hive_database) {
        this.hive_database = hive_database;
    }

    public List<EdgeInput> getEdge_inputs() {
        return this.edge_inputs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPool() {
        return this.pool;
    }

    public void setPool(String pool) {
        this.pool = pool;
    }

    public List<VertexInput> getVertex_inputs() {
        return this.vertex_inputs;
    }

    public VertexOutput getVertex_output() {
        return this.vertex_output;
    }

    public int getWorkers() {
        return this.workers;
    }

    public void setWorkers(int workers) {
        this.workers = workers;
    }

    public static class TypeWithHive
    extends TypeHolder {
        private Object hive_reader;
        private Object hive_writer;
        private Object hive_io;

        public Object getHive_io() {
            return this.hive_io;
        }

        public void setHive_io(Object hive_io) {
            this.hive_io = hive_io;
        }

        public Object getHive_reader() {
            return this.hive_reader;
        }

        public void setHive_reader(Object hive_reader) {
            this.hive_reader = hive_reader;
        }

        public Object getHive_writer() {
            return this.hive_writer;
        }

        public void setHive_writer(Object hive_writer) {
            this.hive_writer = hive_writer;
        }
    }

    public static class TypeHolder {
        private Object type;

        public Object getType() {
            return this.type;
        }

        public void setType(Object type) {
            this.type = type;
        }
    }

    public static class VertexOutput {
        private String table;
        private final Map<String, String> partition = Maps.newHashMap();
        private String id_column;
        private String value_column;

        public String getId_column() {
            return this.id_column;
        }

        public void setId_column(String id_column) {
            this.id_column = id_column;
        }

        public Map<String, String> getPartition() {
            return this.partition;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String getValue_column() {
            return this.value_column;
        }

        public void setValue_column(String value_column) {
            this.value_column = value_column;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.table).add("partition", this.partition).add("id_column", (Object)this.id_column).add("value_column", (Object)this.value_column).toString();
        }
    }

    public static class EdgeInput
    extends InputBase {
        private String source_id_column;
        private String target_id_column;
        private String value_column;

        public String getValue_column() {
            return this.value_column;
        }

        public void setValue_column(String value_column) {
            this.value_column = value_column;
        }

        public String getSource_id_column() {
            return this.source_id_column;
        }

        public void setSource_id_column(String source_id_column) {
            this.source_id_column = source_id_column;
        }

        public String getTarget_id_column() {
            return this.target_id_column;
        }

        public void setTarget_id_column(String target_id_column) {
            this.target_id_column = target_id_column;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.getTable()).add("partition_filter", (Object)this.getPartition_filter()).add("source_id_column", (Object)this.source_id_column).add("target_id_column", (Object)this.target_id_column).add("edge_value_column", (Object)this.value_column).toString();
        }
    }

    public static class VertexInput
    extends InputBase {
        private String id_column;
        private String value_column;

        public String getId_column() {
            return this.id_column;
        }

        public void setId_column(String id_column) {
            this.id_column = id_column;
        }

        public String getValue_column() {
            return this.value_column;
        }

        public void setValue_column(String value_column) {
            this.value_column = value_column;
        }

        @Override
        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.getTable()).add("partition_filter", (Object)this.getPartition_filter()).add("id_column", (Object)this.id_column).add("value_column", (Object)this.value_column).toString();
        }
    }

    public static class InputBase {
        private String table;
        private String partition_filter;

        public String getPartition_filter() {
            return this.partition_filter;
        }

        public void setPartition_filter(String partition_filter) {
            this.partition_filter = partition_filter;
        }

        public String getTable() {
            return this.table;
        }

        public void setTable(String table) {
            this.table = table;
        }

        public String toString() {
            return Objects.toStringHelper((Object)this).add("table", (Object)this.table).add("partition_filter", (Object)this.partition_filter).toString();
        }
    }
}

