/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.giraph.graph.AbstractComputation;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.graph.Language;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.jython.JythonComputation;
import org.apache.giraph.jython.wrappers.JythonWritableWrapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.python.core.PyObject;

public class JythonGiraphComputation<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable>
extends AbstractComputation<I, V, E, M1, M2> {
    private final JythonComputation jythonComputation;

    public JythonGiraphComputation(JythonComputation jythonComputation) {
        this.jythonComputation = jythonComputation;
    }

    @Override
    public void compute(Vertex<I, V, E> vertex, Iterable<M1> messages) throws IOException {
        this.jythonComputation.compute(vertex, messages);
    }

    public WritableComparable wrapIdIfNecessary(Object object) {
        return (WritableComparable)this.wrapIfNecessary(object, GraphType.VERTEX_ID);
    }

    public <W extends Writable> W wrapIfNecessary(Object object, GraphType graphType) {
        if (graphType.interfaceClass().isInstance(object)) {
            return (W)((Writable)object);
        }
        if (this.getConf().getValueLanguages().get(graphType) == Language.JYTHON && this.getConf().getValueNeedsWrappers().get(graphType)) {
            Preconditions.checkArgument((boolean)(object instanceof PyObject));
            return (W)((Object)new JythonWritableWrapper((PyObject)object));
        }
        return (W)((Writable)object);
    }
}

