/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.jython;

import java.io.IOException;
import java.util.Iterator;
import org.apache.giraph.conf.DefaultImmutableClassesGiraphConfigurable;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.GraphType;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.jython.JythonGiraphComputation;
import org.apache.giraph.worker.WorkerContext;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;

public abstract class JythonComputation
extends DefaultImmutableClassesGiraphConfigurable {
    private JythonGiraphComputation giraphCompute;

    public void setGiraphCompute(JythonGiraphComputation giraphCompute) {
        this.giraphCompute = giraphCompute;
    }

    public abstract void compute(Object var1, Iterable var2);

    public void preSuperstep() {
    }

    public void postSuperstep() {
    }

    public long getSuperstep() {
        return this.giraphCompute.getSuperstep();
    }

    public long getTotalNumVertices() {
        return this.giraphCompute.getTotalNumVertices();
    }

    public long getTotalNumEdges() {
        return this.giraphCompute.getTotalNumEdges();
    }

    public void sendMessage(Object id, Object message) {
        WritableComparable wrappedId = this.giraphCompute.wrapIdIfNecessary(id);
        Object wrappedMessage = this.giraphCompute.wrapIfNecessary(message, GraphType.OUTGOING_MESSAGE_VALUE);
        this.giraphCompute.sendMessage(wrappedId, wrappedMessage);
    }

    public void sendMessageToAllEdges(Vertex vertex, Object message) {
        Object wrappedMessage = this.giraphCompute.wrapIfNecessary(message, GraphType.OUTGOING_MESSAGE_VALUE);
        this.giraphCompute.sendMessageToAllEdges(vertex, wrappedMessage);
    }

    public void sendMessageToMultipleEdges(Iterator vertexIdIterator, Object message) {
        Object wrappedMessage = this.giraphCompute.wrapIfNecessary(message, GraphType.OUTGOING_MESSAGE_VALUE);
        this.giraphCompute.sendMessageToMultipleEdges(vertexIdIterator, wrappedMessage);
    }

    public void addVertexRequest(Object id, Object vertexValue, OutEdges edges) throws IOException {
        WritableComparable wrappedId = this.giraphCompute.wrapIdIfNecessary(id);
        Object wrappedValue = this.giraphCompute.wrapIfNecessary(vertexValue, GraphType.VERTEX_VALUE);
        this.giraphCompute.addVertexRequest(wrappedId, wrappedValue, edges);
    }

    public void addVertexRequest(Object id, Object vertexValue) throws IOException {
        WritableComparable wrappedId = this.giraphCompute.wrapIdIfNecessary(id);
        Object wrappedVertexValue = this.giraphCompute.wrapIfNecessary(vertexValue, GraphType.VERTEX_VALUE);
        this.giraphCompute.addVertexRequest(wrappedId, wrappedVertexValue);
    }

    public void removeVertexRequest(Object id) throws IOException {
        WritableComparable wrappedId = this.giraphCompute.wrapIdIfNecessary(id);
        this.giraphCompute.removeVertexRequest(wrappedId);
    }

    public void addEdgeRequest(Object sourceVertexId, Edge edge) throws IOException {
        WritableComparable wrappedSourceId = this.giraphCompute.wrapIdIfNecessary(sourceVertexId);
        this.giraphCompute.addEdgeRequest(wrappedSourceId, edge);
    }

    public void removeEdgesRequest(Object sourceVertexId, Object targetVertexId) throws IOException {
        WritableComparable wrappedSourceVertexId = this.giraphCompute.wrapIdIfNecessary(sourceVertexId);
        WritableComparable wrappedTargetVertexId = this.giraphCompute.wrapIdIfNecessary(targetVertexId);
        this.giraphCompute.removeEdgesRequest(wrappedSourceVertexId, wrappedTargetVertexId);
    }

    public Mapper.Context getContext() {
        return this.giraphCompute.getContext();
    }

    public <W extends WorkerContext> W getWorkerContext() {
        return this.giraphCompute.getWorkerContext();
    }
}

