/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.job;

import com.facebook.nifty.processor.NiftyProcessor;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.service.ThriftServer;
import com.facebook.swift.service.ThriftServerConfig;
import com.facebook.swift.service.ThriftServiceProcessor;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.job.CombinedWorkerProgress;
import org.apache.giraph.job.JobProgressTracker;
import org.apache.giraph.worker.WorkerProgress;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;

public class JobProgressTrackerService
implements JobProgressTracker {
    private static final Logger LOG = Logger.getLogger(JobProgressTrackerService.class);
    private static final int UPDATE_MILLISECONDS = 10000;
    private final GiraphConfiguration conf;
    private Thread writerThread;
    private volatile boolean finished = false;
    private ThriftServer server;
    private int mappersStarted;
    private long lastTimeMappersStartedLogged;
    private final Map<Integer, WorkerProgress> workerProgresses = new ConcurrentHashMap<Integer, WorkerProgress>();
    private Job job;

    public JobProgressTrackerService(GiraphConfiguration conf) {
        this.conf = conf;
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"Waiting for job to start... (this may take a minute)");
        }
        this.startWriterThread();
    }

    private void startWriterThread() {
        this.writerThread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!JobProgressTrackerService.this.finished) {
                    if (JobProgressTrackerService.this.mappersStarted == JobProgressTrackerService.this.conf.getMaxWorkers() + 1 && !JobProgressTrackerService.this.workerProgresses.isEmpty()) {
                        CombinedWorkerProgress combinedWorkerProgress = new CombinedWorkerProgress(JobProgressTrackerService.this.workerProgresses.values());
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)combinedWorkerProgress.toString());
                        }
                        if (combinedWorkerProgress.isDone(JobProgressTrackerService.this.conf.getMaxWorkers())) break;
                    }
                    try {
                        Thread.sleep(10000L);
                    }
                    catch (InterruptedException e) {
                        if (!LOG.isInfoEnabled()) break;
                        LOG.info((Object)"Progress thread interrupted");
                        break;
                    }
                }
            }
        });
        this.writerThread.start();
    }

    public void setJob(Job job) {
        this.job = job;
    }

    private void jobGotAllMappers() {
        final long maxAllowedJobTimeMs = GiraphConstants.MAX_ALLOWED_JOB_TIME_MS.get(this.conf);
        if (maxAllowedJobTimeMs > 0L) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    block4: {
                        try {
                            Thread.sleep(maxAllowedJobTimeMs);
                            try {
                                LOG.warn((Object)("Killing job because it took longer than " + maxAllowedJobTimeMs + " milliseconds"));
                                JobProgressTrackerService.this.job.killJob();
                            }
                            catch (IOException e) {
                                LOG.warn((Object)"Failed to kill job", (Throwable)e);
                            }
                        }
                        catch (InterruptedException e) {
                            if (!LOG.isDebugEnabled()) break block4;
                            LOG.debug((Object)"Thread checking for jobs max allowed time interrupted");
                        }
                    }
                }
            }).start();
        }
    }

    @Override
    public synchronized void mapperStarted() {
        ++this.mappersStarted;
        if (LOG.isInfoEnabled()) {
            if (this.mappersStarted == this.conf.getMaxWorkers() + 1) {
                LOG.info((Object)("Got all " + this.mappersStarted + " mappers"));
                this.jobGotAllMappers();
            } else if (System.currentTimeMillis() - this.lastTimeMappersStartedLogged > 10000L) {
                this.lastTimeMappersStartedLogged = System.currentTimeMillis();
                LOG.info((Object)("Got " + this.mappersStarted + " but needs " + (this.conf.getMaxWorkers() + 1) + " mappers"));
            }
        }
    }

    @Override
    public void logInfo(String logLine) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)logLine);
        }
    }

    @Override
    public void logFailure(String reason) {
        LOG.fatal((Object)reason);
        this.finished = true;
        this.writerThread.interrupt();
    }

    @Override
    public void updateProgress(WorkerProgress workerProgress) {
        this.workerProgresses.put(workerProgress.getTaskId(), workerProgress);
    }

    public void stop(boolean succeeded) {
        this.finished = true;
        this.writerThread.interrupt();
        this.server.close();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Job " + (succeeded ? "finished successfully" : "failed") + ", cleaning up..."));
        }
    }

    public static JobProgressTrackerService createJobProgressServer(GiraphConfiguration conf) {
        if (!conf.trackJobProgressOnClient()) {
            return null;
        }
        try {
            JobProgressTrackerService service = new JobProgressTrackerService(conf);
            ThriftServiceProcessor processor = new ThriftServiceProcessor(new ThriftCodecManager(new ThriftCodec[0]), new ArrayList(), new Object[]{service});
            service.server = new ThriftServer((NiftyProcessor)processor, new ThriftServerConfig());
            service.server.start();
            JOB_PROGRESS_SERVICE_HOST.set(conf, InetAddress.getLocalHost().getHostName());
            JOB_PROGRESS_SERVICE_PORT.set(conf, service.server.getPort());
            return service;
        }
        catch (Exception e) {
            LOG.warn((Object)"Exception occurred while trying to create JobProgressTrackerService - not using progress reporting", (Throwable)e);
            return null;
        }
    }
}

