/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.job;

import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.utils.CounterUtils;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;

public class HaltApplicationUtils {
    private HaltApplicationUtils() {
    }

    public static void printHaltInfo(Job submittedJob, GiraphConfiguration conf) {
        String zkServer = CounterUtils.waitAndGetCounterNameFromGroup(submittedJob, "Zookeeper server:port");
        String haltNode = CounterUtils.waitAndGetCounterNameFromGroup(submittedJob, "Zookeeper halt node");
        if (zkServer != null && haltNode != null) {
            GiraphConstants.HALT_INSTRUCTIONS_WRITER_CLASS.newInstance(conf).writeHaltInstructions(zkServer, haltNode);
        }
    }

    public static class DefaultHaltInstructionsWriter
    implements HaltInstructionsWriter {
        private static final Logger LOG = Logger.getLogger(DefaultHaltInstructionsWriter.class);

        @Override
        public void writeHaltInstructions(String zkServer, String haltNode) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("writeHaltInstructions: To halt after next superstep execute: 'bin/halt-application --zkServer " + zkServer + " --zkNode " + haltNode + "'"));
            }
        }
    }

    public static interface HaltInstructionsWriter {
        public void writeHaltInstructions(String var1, String var2);
    }
}

