/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.job;

import java.io.IOException;
import org.apache.giraph.bsp.BspInputFormat;
import org.apache.giraph.bsp.BspOutputFormat;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.GraphMapper;
import org.apache.giraph.job.GiraphJobObserver;
import org.apache.giraph.job.GiraphJobRetryChecker;
import org.apache.giraph.job.HaltApplicationUtils;
import org.apache.giraph.job.JobProgressTrackerService;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.mapreduce.Job;
import org.apache.log4j.Logger;

public class GiraphJob {
    private static final Logger LOG;
    private final DelegatedJob delegatedJob;
    private String jobName;
    private final GiraphConfiguration giraphConfiguration;

    public GiraphJob(String jobName) throws IOException {
        this(new GiraphConfiguration(), jobName);
    }

    public GiraphJob(Configuration configuration, String jobName) throws IOException {
        this(new GiraphConfiguration(configuration), jobName);
    }

    public GiraphJob(GiraphConfiguration giraphConfiguration, String jobName) throws IOException {
        this.jobName = jobName;
        this.giraphConfiguration = giraphConfiguration;
        this.delegatedJob = new DelegatedJob(giraphConfiguration);
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public GiraphConfiguration getConfiguration() {
        return this.giraphConfiguration;
    }

    public Job getInternalJob() {
        this.delegatedJob.jobInited = true;
        return this.delegatedJob;
    }

    private static void checkLocalJobRunnerConfiguration(ImmutableClassesGiraphConfiguration conf) {
        String jobTracker = conf.get("mapred.job.tracker", null);
        if (!jobTracker.equals("local")) {
            return;
        }
        int maxWorkers = conf.getMaxWorkers();
        if (maxWorkers != 1) {
            throw new IllegalArgumentException("checkLocalJobRunnerConfiguration: When using LocalJobRunner, must have only one worker since only 1 task at a time!");
        }
        if (conf.getSplitMasterWorker()) {
            throw new IllegalArgumentException("checkLocalJobRunnerConfiguration: When using LocalJobRunner, you cannot run in split master / worker mode since there is only 1 task at a time!");
        }
    }

    private void setIntConfIfDefault(String param, int defaultValue) {
        if (this.giraphConfiguration.getInt(param, Integer.MIN_VALUE) == Integer.MIN_VALUE) {
            this.giraphConfiguration.setInt(param, defaultValue);
        }
    }

    public final boolean run(boolean verbose) throws IOException, InterruptedException, ClassNotFoundException {
        this.setIntConfIfDefault("mapreduce.job.counters.limit", 512);
        this.setIntConfIfDefault("mapred.job.map.memory.mb", 1024);
        this.setIntConfIfDefault("mapred.job.reduce.memory.mb", 0);
        this.giraphConfiguration.setBoolean("mapred.map.tasks.speculative.execution", false);
        Client.setPingInterval((Configuration)this.giraphConfiguration, (int)300000);
        this.giraphConfiguration.setBoolean("mapreduce.user.classpath.first", true);
        this.giraphConfiguration.setBoolean("mapreduce.job.user.classpath.first", true);
        if (this.giraphConfiguration.getCheckpointFrequency() == 0) {
            int oldMaxTaskAttempts = this.giraphConfiguration.getMaxTaskAttempts();
            this.giraphConfiguration.setMaxTaskAttempts(0);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("run: Since checkpointing is disabled (default), do not allow any task retries (setting " + GiraphConstants.MAX_TASK_ATTEMPTS.getKey() + " = 0, " + "old value = " + oldMaxTaskAttempts + ")"));
            }
        }
        ImmutableClassesGiraphConfiguration conf = new ImmutableClassesGiraphConfiguration(this.giraphConfiguration);
        GiraphJob.checkLocalJobRunnerConfiguration(conf);
        int tryCount = 0;
        GiraphJobRetryChecker retryChecker = conf.getJobRetryChecker();
        while (true) {
            String restartFrom;
            JobProgressTrackerService jobProgressTrackerService = JobProgressTrackerService.createJobProgressServer(conf);
            ++tryCount;
            Job submittedJob = new Job(conf, this.jobName);
            if (submittedJob.getJar() == null) {
                submittedJob.setJarByClass(this.getClass());
            }
            submittedJob.setNumReduceTasks(0);
            submittedJob.setMapperClass(GraphMapper.class);
            submittedJob.setInputFormatClass(BspInputFormat.class);
            submittedJob.setOutputFormatClass(BspOutputFormat.class);
            if (jobProgressTrackerService != null) {
                jobProgressTrackerService.setJob(submittedJob);
            }
            GiraphJobObserver jobObserver = conf.getJobObserver();
            jobObserver.launchingJob(submittedJob);
            submittedJob.submit();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Tracking URL: " + submittedJob.getTrackingURL()));
                LOG.info((Object)("Waiting for resources... Job will start only when it gets all " + (conf.getMinWorkers() + 1) + " mappers"));
            }
            jobObserver.jobRunning(submittedJob);
            HaltApplicationUtils.printHaltInfo(submittedJob, conf);
            boolean passed = submittedJob.waitForCompletion(verbose);
            if (jobProgressTrackerService != null) {
                jobProgressTrackerService.stop(passed);
            }
            jobObserver.jobFinished(submittedJob, passed);
            if (!passed && (restartFrom = retryChecker.shouldRestartCheckpoint(submittedJob)) != null) {
                GiraphConstants.RESTART_JOB_ID.set(conf, restartFrom);
                continue;
            }
            if (passed || !retryChecker.shouldRetry(submittedJob, tryCount)) {
                return passed;
            }
            if (!LOG.isInfoEnabled()) continue;
            LOG.info((Object)("run: Retrying job, " + tryCount + " try"));
        }
    }

    static {
        Configuration.addDefaultResource((String)"giraph-site.xml");
        LOG = Logger.getLogger(GiraphJob.class);
    }

    private class DelegatedJob
    extends Job {
        private boolean jobInited;

        DelegatedJob(Configuration conf) throws IOException {
            super(conf);
            this.jobInited = false;
        }

        public Configuration getConfiguration() {
            if (this.jobInited) {
                return GiraphJob.this.giraphConfiguration;
            }
            return super.getConfiguration();
        }
    }
}

