/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.job;

import org.apache.giraph.combiner.MessageCombiner;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.factories.DefaultVertexValueFactory;
import org.apache.giraph.factories.VertexValueFactory;
import org.apache.giraph.graph.DefaultVertexResolver;
import org.apache.giraph.graph.VertexResolver;
import org.apache.giraph.graph.VertexValueCombiner;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.utils.ReflectionUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.log4j.Logger;

public class GiraphConfigurationValidator<I extends WritableComparable, V extends Writable, E extends Writable, M1 extends Writable, M2 extends Writable> {
    private static Logger LOG = Logger.getLogger(GiraphConfigurationValidator.class);
    private static final int ID_PARAM_INDEX = 0;
    private static final int VALUE_PARAM_INDEX = 1;
    private static final int EDGE_PARAM_INDEX = 2;
    private static final int MSG_COMBINER_PARAM_INDEX = 1;
    private static final int EDGE_PARAM_EDGE_INPUT_FORMAT_INDEX = 1;
    private static final int EDGE_PARAM_OUT_EDGES_INDEX = 1;
    private static final int VALUE_PARAM_VERTEX_VALUE_FACTORY_INDEX = 0;
    private static final int VALUE_PARAM_VERTEX_VALUE_COMBINER_INDEX = 0;
    private ImmutableClassesGiraphConfiguration conf;

    public GiraphConfigurationValidator(Configuration conf) {
        this.conf = new ImmutableClassesGiraphConfiguration(conf);
    }

    private Class<? extends WritableComparable> vertexIndexType() {
        return this.conf.getGiraphTypes().getVertexIdClass();
    }

    private Class<? extends Writable> vertexValueType() {
        return this.conf.getGiraphTypes().getVertexValueClass();
    }

    private Class<? extends Writable> edgeValueType() {
        return this.conf.getGiraphTypes().getEdgeValueClass();
    }

    private Class<? extends Writable> outgoingMessageValueType() {
        return this.conf.getGiraphTypes().getOutgoingMessageValueClass();
    }

    public void validateConfiguration() {
        this.checkConfiguration();
        this.verifyOutEdgesGenericTypes();
        this.verifyVertexInputFormatGenericTypes();
        this.verifyEdgeInputFormatGenericTypes();
        this.verifyVertexOutputFormatGenericTypes();
        this.verifyEdgeOutputFormatGenericTypes();
        this.verifyVertexResolverGenericTypes();
        this.verifyVertexValueCombinerGenericTypes();
        this.verifyMessageCombinerGenericTypes();
        this.verifyVertexValueFactoryGenericTypes();
    }

    private void checkConfiguration() {
        if (this.conf.getMaxWorkers() < 0) {
            throw new RuntimeException("checkConfiguration: No valid giraph.maxWorkers");
        }
        if (this.conf.getMinPercentResponded() <= 0.0f || this.conf.getMinPercentResponded() > 100.0f) {
            throw new IllegalArgumentException("checkConfiguration: Invalid " + this.conf.getMinPercentResponded() + " for " + GiraphConstants.MIN_PERCENT_RESPONDED.getKey());
        }
        if (this.conf.getMinWorkers() < 0) {
            throw new IllegalArgumentException("checkConfiguration: No valid giraph.minWorkers");
        }
        this.conf.createComputationFactory().checkConfiguration(this.conf);
        if (this.conf.getVertexInputFormatClass() == null && this.conf.getEdgeInputFormatClass() == null) {
            throw new IllegalArgumentException("checkConfiguration: One of " + GiraphConstants.VERTEX_INPUT_FORMAT_CLASS.getKey() + " and " + GiraphConstants.EDGE_INPUT_FORMAT_CLASS.getKey() + " must be non-null");
        }
        if (this.conf.getVertexResolverClass() == null && LOG.isInfoEnabled()) {
            LOG.info((Object)("checkConfiguration: No class found for " + GiraphConstants.VERTEX_RESOLVER_CLASS.getKey() + ", defaulting to " + GiraphConstants.VERTEX_RESOLVER_CLASS.getDefaultClass().getCanonicalName()));
        }
        if (this.conf.getOutEdgesClass() == null && LOG.isInfoEnabled()) {
            LOG.info((Object)("checkConfiguration: No class found for " + GiraphConstants.VERTEX_EDGES_CLASS.getKey() + ", defaulting to " + GiraphConstants.VERTEX_EDGES_CLASS.getDefaultClass().getCanonicalName()));
        }
    }

    private void verifyOutEdgesGenericTypesClass(Class<? extends OutEdges<I, E>> outEdgesClass) {
        Class<?>[] classList = ReflectionUtils.getTypeArguments(OutEdges.class, outEdgesClass);
        GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexIndexType(), OutEdges.class, "vertex index");
        GiraphConfigurationValidator.checkAssignable(classList, 1, this.edgeValueType(), OutEdges.class, "edge value");
    }

    private void verifyOutEdgesGenericTypes() {
        Class outEdgesClass = this.conf.getOutEdgesClass();
        Class inputOutEdgesClass = this.conf.getInputOutEdgesClass();
        this.verifyOutEdgesGenericTypesClass(outEdgesClass);
        this.verifyOutEdgesGenericTypesClass(inputOutEdgesClass);
    }

    private void verifyVertexInputFormatGenericTypes() {
        Class vertexInputFormatClass = this.conf.getVertexInputFormatClass();
        if (vertexInputFormatClass != null) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(VertexInputFormat.class, vertexInputFormatClass);
            GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexIndexType(), VertexInputFormat.class, "vertex index");
            GiraphConfigurationValidator.checkAssignable(classList, 1, this.vertexValueType(), VertexInputFormat.class, "vertex value");
            GiraphConfigurationValidator.checkAssignable(classList, 2, this.edgeValueType(), VertexInputFormat.class, "edge value");
        }
    }

    private void verifyEdgeInputFormatGenericTypes() {
        Class edgeInputFormatClass = this.conf.getEdgeInputFormatClass();
        if (edgeInputFormatClass != null) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(EdgeInputFormat.class, edgeInputFormatClass);
            GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexIndexType(), EdgeInputFormat.class, "vertex index");
            GiraphConfigurationValidator.checkAssignable(classList, 1, this.edgeValueType(), EdgeInputFormat.class, "edge value");
        }
    }

    private void verifyVertexValueCombinerGenericTypes() {
        Class vertexValueCombiner = this.conf.getVertexValueCombinerClass();
        if (vertexValueCombiner != null) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(VertexValueCombiner.class, vertexValueCombiner);
            GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexValueType(), VertexValueCombiner.class, "vertex value");
        }
    }

    private void verifyMessageCombinerGenericTypes() {
        Class messageCombinerClass = this.conf.getMessageCombinerClass();
        if (messageCombinerClass != null) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(MessageCombiner.class, messageCombinerClass);
            GiraphConfigurationValidator.checkEquals(classList, 0, this.vertexIndexType(), MessageCombiner.class, "vertex index");
            GiraphConfigurationValidator.checkEquals(classList, 1, this.outgoingMessageValueType(), MessageCombiner.class, "message value");
        }
    }

    private void verifyVertexOutputFormatGenericTypes() {
        Class edgeOutputFormatClass = this.conf.getEdgeOutputFormatClass();
        if (this.conf.hasEdgeOutputFormat()) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(EdgeOutputFormat.class, edgeOutputFormatClass);
            GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexIndexType(), VertexOutputFormat.class, "vertex index");
            GiraphConfigurationValidator.checkAssignable(classList, 1, this.vertexValueType(), VertexOutputFormat.class, "vertex value");
            GiraphConfigurationValidator.checkAssignable(classList, 2, this.edgeValueType(), VertexOutputFormat.class, "edge value");
        }
    }

    private void verifyEdgeOutputFormatGenericTypes() {
        Class vertexOutputFormatClass = this.conf.getVertexOutputFormatClass();
        if (this.conf.hasVertexOutputFormat()) {
            Class<?>[] classList = ReflectionUtils.getTypeArguments(VertexOutputFormat.class, vertexOutputFormatClass);
            GiraphConfigurationValidator.checkAssignable(classList, 0, this.vertexIndexType(), VertexOutputFormat.class, "vertex index");
            GiraphConfigurationValidator.checkAssignable(classList, 1, this.vertexValueType(), VertexOutputFormat.class, "vertex value");
            GiraphConfigurationValidator.checkAssignable(classList, 2, this.edgeValueType(), VertexOutputFormat.class, "edge value");
        }
    }

    private void verifyVertexValueFactoryGenericTypes() {
        Class vvfClass = this.conf.getVertexValueFactoryClass();
        if (DefaultVertexValueFactory.class.equals(vvfClass)) {
            return;
        }
        Class<?>[] classList = ReflectionUtils.getTypeArguments(VertexValueFactory.class, vvfClass);
        GiraphConfigurationValidator.checkEquals(classList, 0, this.vertexValueType(), VertexValueFactory.class, "vertex value");
    }

    private void verifyVertexResolverGenericTypes() {
        Class vrClass = this.conf.getVertexResolverClass();
        if (DefaultVertexResolver.class.equals(vrClass)) {
            return;
        }
        Class<?>[] classList = ReflectionUtils.getTypeArguments(VertexResolver.class, vrClass);
        GiraphConfigurationValidator.checkEquals(classList, 0, this.vertexIndexType(), VertexResolver.class, "vertex index");
        GiraphConfigurationValidator.checkEquals(classList, 1, this.vertexValueType(), VertexResolver.class, "vertex value");
        GiraphConfigurationValidator.checkEquals(classList, 2, this.edgeValueType(), VertexResolver.class, "edge value");
    }

    private static void checkEquals(Class<?>[] classList, int index, Class<?> classFromComputation, Class klass, String typeName) {
        if (classList[index] == null) {
            LOG.warn((Object)(klass.getSimpleName() + " " + typeName + " type is not known"));
        } else if (!classList[index].equals(classFromComputation)) {
            throw new IllegalArgumentException("checkClassTypes: " + typeName + " types not equal, " + "computation - " + classFromComputation + ", " + klass.getSimpleName() + " - " + classList[index]);
        }
    }

    private static void checkAssignable(Class<?>[] classList, int index, Class<?> classFromComputation, Class klass, String typeName) {
        if (classList[index] == null) {
            LOG.warn((Object)(klass.getSimpleName() + " " + typeName + " type is not known"));
        } else if (!classList[index].isAssignableFrom(classFromComputation)) {
            throw new IllegalArgumentException("checkClassTypes: " + typeName + " types not assignable, " + "computation - " + classFromComputation + ", " + klass.getSimpleName() + " - " + classList[1]);
        }
    }
}

