/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.job;

import com.google.common.collect.Iterables;
import java.text.DecimalFormat;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.giraph.worker.WorkerProgress;

@NotThreadSafe
public class CombinedWorkerProgress
extends WorkerProgress {
    public static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("#.##");
    private int workersInSuperstep = 0;
    private int workersDone = 0;
    private double minFreeMemoryMB = Double.MAX_VALUE;
    private int workerWithMinFreeMemory;

    public CombinedWorkerProgress(Iterable<WorkerProgress> workerProgresses) {
        for (WorkerProgress workerProgress : workerProgresses) {
            if (workerProgress.getCurrentSuperstep() > this.currentSuperstep) {
                this.verticesToCompute = 0L;
                this.verticesComputed = 0L;
                this.partitionsToCompute = 0;
                this.partitionsComputed = 0;
                this.currentSuperstep = workerProgress.getCurrentSuperstep();
                this.workersInSuperstep = 0;
            }
            if (workerProgress.getCurrentSuperstep() == this.currentSuperstep) {
                ++this.workersInSuperstep;
                if (this.isInputSuperstep()) {
                    this.verticesLoaded += workerProgress.getVerticesLoaded();
                    this.vertexInputSplitsLoaded += workerProgress.getVertexInputSplitsLoaded();
                    this.edgesLoaded += workerProgress.getEdgesLoaded();
                    this.edgeInputSplitsLoaded += workerProgress.getEdgeInputSplitsLoaded();
                } else if (this.isComputeSuperstep()) {
                    this.verticesToCompute += workerProgress.getVerticesToCompute();
                    this.verticesComputed += workerProgress.getVerticesComputed();
                    this.partitionsToCompute += workerProgress.getPartitionsToCompute();
                    this.partitionsComputed += workerProgress.getPartitionsComputed();
                } else if (this.isOutputSuperstep()) {
                    this.verticesToStore += workerProgress.getVerticesToStore();
                    this.verticesStored += workerProgress.getVerticesStored();
                    this.partitionsToStore += workerProgress.getPartitionsToStore();
                    this.partitionsStored += workerProgress.getPartitionsStored();
                }
            }
            if (workerProgress.isStoringDone()) {
                ++this.workersDone;
            }
            if (workerProgress.getFreeMemoryMB() < this.minFreeMemoryMB) {
                this.minFreeMemoryMB = workerProgress.getFreeMemoryMB();
                this.workerWithMinFreeMemory = workerProgress.getTaskId();
            }
            this.freeMemoryMB += workerProgress.getFreeMemoryMB();
        }
        if (!Iterables.isEmpty(workerProgresses)) {
            this.freeMemoryMB /= (double)Iterables.size(workerProgresses);
        }
    }

    public boolean isDone(int expectedWorkersDone) {
        return this.workersDone == expectedWorkersDone;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Data from ").append(this.workersInSuperstep).append(" workers - ");
        if (this.isInputSuperstep()) {
            sb.append("Loading data: ");
            sb.append(this.verticesLoaded).append(" vertices loaded, ");
            sb.append(this.vertexInputSplitsLoaded).append(" vertex input splits loaded; ");
            sb.append(this.edgesLoaded).append(" edges loaded, ");
            sb.append(this.edgeInputSplitsLoaded).append(" edge input splits loaded");
        } else if (this.isComputeSuperstep()) {
            sb.append("Compute superstep ").append(this.currentSuperstep).append(": ");
            sb.append(this.verticesComputed).append(" out of ").append(this.verticesToCompute).append(" vertices computed; ");
            sb.append(this.partitionsComputed).append(" out of ").append(this.partitionsToCompute).append(" partitions computed");
        } else if (this.isOutputSuperstep()) {
            sb.append("Storing data: ");
            sb.append(this.verticesStored).append(" out of ").append(this.verticesToStore).append(" vertices stored; ");
            sb.append(this.partitionsStored).append(" out of ").append(this.partitionsToStore).append(" partitions stored");
        }
        sb.append("; min free memory on worker ").append(this.workerWithMinFreeMemory).append(" - ").append(DECIMAL_FORMAT.format(this.minFreeMemoryMB)).append("MB, average ").append(DECIMAL_FORMAT.format(this.freeMemoryMB)).append("MB");
        return sb.toString();
    }
}

