/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.superstep_output;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.SimpleVertexWriter;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.superstep_output.SuperstepOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SynchronizedSuperstepOutput<I extends WritableComparable, V extends Writable, E extends Writable>
implements SuperstepOutput<I, V, E> {
    private final Mapper.Context context;
    private final VertexWriter<I, V, E> vertexWriter;
    private final SimpleVertexWriter<I, V, E> simpleVertexWriter;

    public SynchronizedSuperstepOutput(ImmutableClassesGiraphConfiguration<I, V, E> conf, Mapper.Context context) {
        this.context = context;
        try {
            this.vertexWriter = conf.createWrappedVertexOutputFormat().createVertexWriter((TaskAttemptContext)context);
            this.vertexWriter.setConf(conf);
            this.vertexWriter.initialize((TaskAttemptContext)context);
        }
        catch (IOException e) {
            throw new IllegalStateException("SynchronizedSuperstepOutput: IOException occurred", e);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException("SynchronizedSuperstepOutput: InterruptedException occurred", e);
        }
        this.simpleVertexWriter = new SimpleVertexWriter<I, V, E>(){

            @Override
            public synchronized void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
                SynchronizedSuperstepOutput.this.vertexWriter.writeVertex(vertex);
            }
        };
    }

    @Override
    public SimpleVertexWriter<I, V, E> getVertexWriter() {
        return this.simpleVertexWriter;
    }

    @Override
    public void returnVertexWriter(SimpleVertexWriter<I, V, E> vertexWriter) {
    }

    @Override
    public void postApplication() throws IOException, InterruptedException {
        this.vertexWriter.close((TaskAttemptContext)this.context);
    }
}

