/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.superstep_output;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.SimpleVertexWriter;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.superstep_output.SuperstepOutput;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiThreadedSuperstepOutput<I extends WritableComparable, V extends Writable, E extends Writable>
implements SuperstepOutput<I, V, E> {
    private final Mapper.Context context;
    private ImmutableClassesGiraphConfiguration<I, V, E> configuration;
    private final VertexOutputFormat<I, V, E> vertexOutputFormat;
    private final List<VertexWriter<I, V, E>> availableVertexWriters;
    private final Set<VertexWriter<I, V, E>> occupiedVertexWriters;

    public MultiThreadedSuperstepOutput(ImmutableClassesGiraphConfiguration<I, V, E> conf, Mapper.Context context) {
        this.configuration = conf;
        this.vertexOutputFormat = conf.createWrappedVertexOutputFormat();
        this.context = context;
        this.availableVertexWriters = Lists.newArrayList();
        this.occupiedVertexWriters = Sets.newHashSet();
    }

    @Override
    public synchronized SimpleVertexWriter<I, V, E> getVertexWriter() {
        VertexWriter<I, V, E> vertexWriter;
        if (this.availableVertexWriters.isEmpty()) {
            try {
                vertexWriter = this.vertexOutputFormat.createVertexWriter((TaskAttemptContext)this.context);
                vertexWriter.setConf(this.configuration);
                vertexWriter.initialize((TaskAttemptContext)this.context);
            }
            catch (IOException e) {
                throw new IllegalStateException("getVertexWriter: IOException occurred", e);
            }
            catch (InterruptedException e) {
                throw new IllegalStateException("getVertexWriter: InterruptedException occurred", e);
            }
        } else {
            vertexWriter = this.availableVertexWriters.remove(this.availableVertexWriters.size() - 1);
        }
        this.occupiedVertexWriters.add(vertexWriter);
        return vertexWriter;
    }

    @Override
    public synchronized void returnVertexWriter(SimpleVertexWriter<I, V, E> vertexWriter) {
        VertexWriter returnedWriter = (VertexWriter)vertexWriter;
        if (!this.occupiedVertexWriters.remove(returnedWriter)) {
            throw new IllegalStateException("returnVertexWriter: Returned vertex writer which is not currently occupied!");
        }
        this.availableVertexWriters.add(returnedWriter);
    }

    @Override
    public synchronized void postApplication() throws IOException, InterruptedException {
        if (!this.occupiedVertexWriters.isEmpty()) {
            throw new IllegalStateException("postApplication: " + this.occupiedVertexWriters.size() + " vertex writers were not returned!");
        }
        for (VertexWriter<I, V, E> vertexWriter : this.availableVertexWriters) {
            vertexWriter.close((TaskAttemptContext)this.context);
        }
    }
}

