/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.iterables;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.giraph.io.iterables.IteratorToReaderWrapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class VertexReaderWrapper<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexReader<I, V, E> {
    private GiraphReader<Vertex<I, V, E>> vertexReader;
    private IteratorToReaderWrapper<Vertex<I, V, E>> iterator;

    public VertexReaderWrapper(GiraphReader<Vertex<I, V, E>> vertexReader) {
        this.vertexReader = vertexReader;
        this.iterator = new IteratorToReaderWrapper<Vertex<I, V, E>>(vertexReader);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        conf.configureIfPossible(this.vertexReader);
    }

    @Override
    public boolean nextVertex() throws IOException, InterruptedException {
        return this.iterator.nextObject();
    }

    @Override
    public Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
        return this.iterator.getCurrentObject();
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.vertexReader.initialize(inputSplit, context);
    }

    @Override
    public void close() throws IOException {
        this.vertexReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.vertexReader.getProgress();
    }
}

