/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.iterables;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.MappingReader;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.giraph.io.iterables.IteratorToReaderWrapper;
import org.apache.giraph.mapping.MappingEntry;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MappingReaderWrapper<I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable>
extends MappingReader<I, V, E, B> {
    private GiraphReader<MappingEntry<I, B>> mappingReader;
    private IteratorToReaderWrapper<MappingEntry<I, B>> iterator;

    public MappingReaderWrapper(GiraphReader<MappingEntry<I, B>> mappingReader) {
        this.mappingReader = mappingReader;
        this.iterator = new IteratorToReaderWrapper<MappingEntry<I, B>>(mappingReader);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        conf.configureIfPossible(this.mappingReader);
    }

    @Override
    public boolean nextEntry() throws IOException, InterruptedException {
        return this.iterator.nextObject();
    }

    @Override
    public MappingEntry<I, B> getCurrentEntry() throws IOException, InterruptedException {
        return this.iterator.getCurrentObject();
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.mappingReader.initialize(inputSplit, context);
    }

    @Override
    public void close() throws IOException {
        this.mappingReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.mappingReader.getProgress();
    }
}

