/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.iterables;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.iterables.EdgeWithSource;
import org.apache.giraph.io.iterables.GiraphReader;
import org.apache.giraph.io.iterables.IteratorToReaderWrapper;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class EdgeReaderWrapper<I extends WritableComparable, E extends Writable>
extends EdgeReader<I, E> {
    private GiraphReader<EdgeWithSource<I, E>> edgeReader;
    private IteratorToReaderWrapper<EdgeWithSource<I, E>> iterator;

    public EdgeReaderWrapper(GiraphReader<EdgeWithSource<I, E>> edgeReader) {
        this.edgeReader = edgeReader;
        this.iterator = new IteratorToReaderWrapper<EdgeWithSource<I, E>>(edgeReader);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        super.setConf(conf);
        conf.configureIfPossible(this.edgeReader);
    }

    @Override
    public boolean nextEdge() throws IOException, InterruptedException {
        return this.iterator.nextObject();
    }

    @Override
    public I getCurrentSourceId() throws IOException, InterruptedException {
        return this.iterator.getCurrentObject().getSourceVertexId();
    }

    @Override
    public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
        return this.iterator.getCurrentObject().getEdge();
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.edgeReader.initialize(inputSplit, context);
    }

    @Override
    public void close() throws IOException {
        this.edgeReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.edgeReader.getProgress();
    }
}

