/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.job.HadoopUtils;
import org.apache.giraph.worker.WorkerGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedVertexReader<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexReader<I, V, E> {
    private final VertexReader<I, V, E> baseVertexReader;

    public WrappedVertexReader(VertexReader<I, V, E> baseVertexReader, ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        this.baseVertexReader = baseVertexReader;
        super.setConf(conf);
        baseVertexReader.setConf(conf);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.baseVertexReader.initialize(inputSplit, HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
    }

    @Override
    public void setWorkerGlobalCommUsage(WorkerGlobalCommUsage usage) {
        super.setWorkerGlobalCommUsage(usage);
        this.baseVertexReader.setWorkerGlobalCommUsage(usage);
    }

    @Override
    public boolean nextVertex() throws IOException, InterruptedException {
        return this.baseVertexReader.nextVertex();
    }

    @Override
    public Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
        return this.baseVertexReader.getCurrentVertex();
    }

    @Override
    public void close() throws IOException {
        this.baseVertexReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.baseVertexReader.getProgress();
    }
}

