/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.job.HadoopUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    private VertexOutputFormat<I, V, E> originalOutputFormat;

    public WrappedVertexOutputFormat(VertexOutputFormat<I, V, E> vertexOutputFormat) {
        this.originalOutputFormat = vertexOutputFormat;
    }

    @Override
    public VertexWriter<I, V, E> createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        final VertexWriter<I, V, E> vertexWriter = this.originalOutputFormat.createVertexWriter(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new VertexWriter<I, V, E>(){

            @Override
            public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
                super.setConf(conf);
                vertexWriter.setConf(conf);
            }

            @Override
            public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
                vertexWriter.initialize(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                vertexWriter.close(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
            }

            @Override
            public void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
                vertexWriter.writeVertex(vertex);
            }
        };
    }

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.originalOutputFormat.checkOutputSpecs(HadoopUtils.makeJobContext(this.getConf(), context));
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        final OutputCommitter outputCommitter = this.originalOutputFormat.getOutputCommitter(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new OutputCommitter(){

            public void setupJob(JobContext context) throws IOException {
                outputCommitter.setupJob(HadoopUtils.makeJobContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void setupTask(TaskAttemptContext context) throws IOException {
                outputCommitter.setupTask(HadoopUtils.makeTaskAttemptContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
                return outputCommitter.needsTaskCommit(HadoopUtils.makeTaskAttemptContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void commitTask(TaskAttemptContext context) throws IOException {
                outputCommitter.commitTask(HadoopUtils.makeTaskAttemptContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void abortTask(TaskAttemptContext context) throws IOException {
                outputCommitter.abortTask(HadoopUtils.makeTaskAttemptContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void cleanupJob(JobContext context) throws IOException {
                outputCommitter.cleanupJob(HadoopUtils.makeJobContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void commitJob(JobContext context) throws IOException {
                outputCommitter.commitJob(HadoopUtils.makeJobContext(WrappedVertexOutputFormat.this.getConf(), context));
            }

            public void abortJob(JobContext context, JobStatus.State state) throws IOException {
                outputCommitter.abortJob(HadoopUtils.makeJobContext(WrappedVertexOutputFormat.this.getConf(), context), state);
            }
        };
    }
}

