/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.internal.WrappedVertexReader;
import org.apache.giraph.job.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private VertexInputFormat<I, V, E> originalInputFormat;

    public WrappedVertexInputFormat(VertexInputFormat<I, V, E> vertexInputFormat) {
        this.originalInputFormat = vertexInputFormat;
    }

    @Override
    public void checkInputSpecs(Configuration conf) {
        this.originalInputFormat.checkInputSpecs(this.getConf());
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.originalInputFormat.getSplits(HadoopUtils.makeJobContext(this.getConf(), context), minSplitCountHint);
    }

    @Override
    public VertexReader<I, V, E> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        VertexReader<I, V, E> vertexReader = this.originalInputFormat.createVertexReader(split, HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new WrappedVertexReader<I, V, E>(vertexReader, this.getConf());
    }

    @Override
    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        this.originalInputFormat.writeInputSplit(inputSplit, dataOutput);
    }

    @Override
    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        return this.originalInputFormat.readInputSplit(dataInput);
    }
}

