/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.MappingInputFormat;
import org.apache.giraph.io.MappingReader;
import org.apache.giraph.io.internal.WrappedMappingReader;
import org.apache.giraph.job.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedMappingInputFormat<I extends WritableComparable, V extends Writable, E extends Writable, B extends Writable>
extends MappingInputFormat<I, V, E, B> {
    private MappingInputFormat<I, V, E, B> originalInputFormat;

    public WrappedMappingInputFormat(MappingInputFormat<I, V, E, B> mappingInputFormat) {
        this.originalInputFormat = mappingInputFormat;
    }

    @Override
    public void checkInputSpecs(Configuration conf) {
        this.originalInputFormat.checkInputSpecs(conf);
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.originalInputFormat.getSplits(HadoopUtils.makeJobContext(this.getConf(), context), minSplitCountHint);
    }

    @Override
    public MappingReader<I, V, E, B> createMappingReader(InputSplit split, TaskAttemptContext context) throws IOException {
        MappingReader<I, V, E, B> mappingReader = this.originalInputFormat.createMappingReader(split, HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new WrappedMappingReader<I, V, E, B>(mappingReader, this.getConf());
    }

    @Override
    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        this.originalInputFormat.writeInputSplit(inputSplit, dataOutput);
    }

    @Override
    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        return this.originalInputFormat.readInputSplit(dataInput);
    }
}

