/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.job.HadoopUtils;
import org.apache.giraph.worker.WorkerGlobalCommUsage;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedEdgeReader<I extends WritableComparable, E extends Writable>
extends EdgeReader<I, E> {
    private final EdgeReader<I, E> baseEdgeReader;

    public WrappedEdgeReader(EdgeReader<I, E> baseEdgeReader, ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        this.baseEdgeReader = baseEdgeReader;
        super.setConf(conf);
        baseEdgeReader.setConf(conf);
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
    }

    @Override
    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
        this.baseEdgeReader.initialize(inputSplit, HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
    }

    @Override
    public void setWorkerGlobalCommUsage(WorkerGlobalCommUsage usage) {
        super.setWorkerGlobalCommUsage(usage);
        this.baseEdgeReader.setWorkerGlobalCommUsage(usage);
    }

    @Override
    public boolean nextEdge() throws IOException, InterruptedException {
        return this.baseEdgeReader.nextEdge();
    }

    @Override
    public I getCurrentSourceId() throws IOException, InterruptedException {
        return this.baseEdgeReader.getCurrentSourceId();
    }

    @Override
    public Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
        return this.baseEdgeReader.getCurrentEdge();
    }

    @Override
    public void close() throws IOException {
        this.baseEdgeReader.close();
    }

    @Override
    public float getProgress() throws IOException, InterruptedException {
        return this.baseEdgeReader.getProgress();
    }
}

