/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.IOException;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.EdgeWriter;
import org.apache.giraph.job.HadoopUtils;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.JobStatus;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedEdgeOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends EdgeOutputFormat<I, V, E> {
    private final EdgeOutputFormat<I, V, E> originalOutputFormat;

    public WrappedEdgeOutputFormat(EdgeOutputFormat<I, V, E> edgeOutputFormat) {
        this.originalOutputFormat = edgeOutputFormat;
    }

    @Override
    public EdgeWriter<I, V, E> createEdgeWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        final EdgeWriter<I, V, E> edgeWriter = this.originalOutputFormat.createEdgeWriter(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new EdgeWriter<I, V, E>(){

            @Override
            public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
                super.setConf(conf);
                edgeWriter.setConf(conf);
            }

            @Override
            public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
                edgeWriter.initialize(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
                edgeWriter.close(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
            }

            @Override
            public void writeEdge(I sourceId, V sourceValue, Edge<I, E> edge) throws IOException, InterruptedException {
                edgeWriter.writeEdge(sourceId, sourceValue, edge);
            }
        };
    }

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.originalOutputFormat.checkOutputSpecs(HadoopUtils.makeJobContext(this.getConf(), context));
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        final OutputCommitter outputCommitter = this.originalOutputFormat.getOutputCommitter(HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new OutputCommitter(){

            public void setupJob(JobContext context) throws IOException {
                outputCommitter.setupJob(HadoopUtils.makeJobContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void setupTask(TaskAttemptContext context) throws IOException {
                outputCommitter.setupTask(HadoopUtils.makeTaskAttemptContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public boolean needsTaskCommit(TaskAttemptContext context) throws IOException {
                return outputCommitter.needsTaskCommit(HadoopUtils.makeTaskAttemptContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void commitTask(TaskAttemptContext context) throws IOException {
                outputCommitter.commitTask(HadoopUtils.makeTaskAttemptContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void abortTask(TaskAttemptContext context) throws IOException {
                outputCommitter.abortTask(HadoopUtils.makeTaskAttemptContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void cleanupJob(JobContext context) throws IOException {
                outputCommitter.cleanupJob(HadoopUtils.makeJobContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void commitJob(JobContext context) throws IOException {
                outputCommitter.commitJob(HadoopUtils.makeJobContext(WrappedEdgeOutputFormat.this.getConf(), context));
            }

            public void abortJob(JobContext context, JobStatus.State state) throws IOException {
                outputCommitter.abortJob(HadoopUtils.makeJobContext(WrappedEdgeOutputFormat.this.getConf(), context), state);
            }
        };
    }
}

