/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.internal;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.internal.WrappedEdgeReader;
import org.apache.giraph.job.HadoopUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WrappedEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private EdgeInputFormat<I, E> originalInputFormat;

    public WrappedEdgeInputFormat(EdgeInputFormat<I, E> edgeInputFormat) {
        this.originalInputFormat = edgeInputFormat;
    }

    @Override
    public void checkInputSpecs(Configuration conf) {
        this.originalInputFormat.checkInputSpecs(this.getConf());
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.originalInputFormat.getSplits(HadoopUtils.makeJobContext(this.getConf(), context), minSplitCountHint);
    }

    @Override
    public EdgeReader<I, E> createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
        EdgeReader<I, E> edgeReader = this.originalInputFormat.createEdgeReader(split, HadoopUtils.makeTaskAttemptContext(this.getConf(), context));
        return new WrappedEdgeReader<I, E>(edgeReader, this.getConf());
    }

    @Override
    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        this.originalInputFormat.writeInputSplit(inputSplit, dataOutput);
    }

    @Override
    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        return this.originalInputFormat.readInputSplit(dataInput);
    }
}

