/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.formats.multi.InputFormatDescription;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.json.JSONArray;
import org.json.JSONException;

public class VertexInputFormatDescription<I extends WritableComparable, V extends Writable, E extends Writable>
extends InputFormatDescription<VertexInputFormat<I, V, E>> {
    public static final StrConfOption VERTEX_INPUT_FORMAT_DESCRIPTIONS = new StrConfOption("giraph.multiVertexInput.descriptions", null, "VertexInputFormats description - JSON array containing a JSON array for each vertex input. Vertex input JSON arrays contain one or two elements - first one is the name of vertex input class, and second one is JSON object with all specific parameters for this vertex input. For example: [[\"VIF1\",{\"p\":\"v1\"}],[\"VIF2\",{\"p\":\"v2\",\"q\":\"v\"}]]\"");

    public VertexInputFormatDescription(Class<? extends VertexInputFormat<I, V, E>> vertexInputFormatClass) {
        super(vertexInputFormatClass);
    }

    public VertexInputFormatDescription(String description) {
        super(description);
    }

    private ImmutableClassesGiraphConfiguration<I, V, E> createConfigurationCopy(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        ImmutableClassesGiraphConfiguration confCopy = new ImmutableClassesGiraphConfiguration(conf);
        confCopy.setVertexInputFormatClass(this.getInputFormatClass());
        this.putParametersToConfiguration(confCopy);
        return confCopy;
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> List<VertexInputFormatDescription<I, V, E>> getVertexInputFormatDescriptions(Configuration conf) {
        String vertexInputFormatDescriptions = VERTEX_INPUT_FORMAT_DESCRIPTIONS.get(conf);
        if (vertexInputFormatDescriptions == null) {
            return Lists.newArrayList();
        }
        try {
            JSONArray inputFormatsJson = new JSONArray(vertexInputFormatDescriptions);
            ArrayList descriptions = Lists.newArrayListWithCapacity((int)inputFormatsJson.length());
            for (int i = 0; i < inputFormatsJson.length(); ++i) {
                descriptions.add(new VertexInputFormatDescription<I, V, E>(inputFormatsJson.getString(i)));
            }
            return descriptions;
        }
        catch (JSONException e) {
            throw new IllegalStateException("getVertexInputFormatDescriptions: JSONException occurred while trying to process " + vertexInputFormatDescriptions, e);
        }
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> List<VertexInputFormat<I, V, E>> createVertexInputFormats(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        List<VertexInputFormatDescription<I, V, E>> descriptions = VertexInputFormatDescription.getVertexInputFormatDescriptions(conf);
        ArrayList vertexInputFormats = Lists.newArrayListWithCapacity((int)descriptions.size());
        for (VertexInputFormatDescription<I, V, E> description : descriptions) {
            ImmutableClassesGiraphConfiguration<I, V, E> confCopy = super.createConfigurationCopy(conf);
            vertexInputFormats.add(confCopy.createWrappedVertexInputFormat());
        }
        return vertexInputFormats;
    }
}

