/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.multi.InputSplitWithInputFormatIndex;
import org.apache.giraph.io.formats.multi.MultiInputUtils;
import org.apache.giraph.io.formats.multi.VertexInputFormatDescription;
import org.apache.giraph.io.internal.WrappedVertexReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    private List<VertexInputFormat<I, V, E>> vertexInputFormats;

    @Override
    public void checkInputSpecs(Configuration conf) {
        for (VertexInputFormat<I, V, E> vertexInputFormat : this.vertexInputFormats) {
            vertexInputFormat.checkInputSpecs(conf);
        }
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, V, E> conf) {
        super.setConf(conf);
        this.vertexInputFormats = VertexInputFormatDescription.createVertexInputFormats(this.getConf());
        if (this.vertexInputFormats.isEmpty()) {
            throw new IllegalStateException("setConf: Using MultiVertexInputFormat without specifying vertex inputs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public VertexReader<I, V, E> createVertexReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        if (inputSplit instanceof InputSplitWithInputFormatIndex) {
            TaskAttemptContext taskAttemptContext = context;
            synchronized (taskAttemptContext) {
                InputSplitWithInputFormatIndex split = (InputSplitWithInputFormatIndex)inputSplit;
                VertexInputFormat<I, V, E> vertexInputFormat = this.vertexInputFormats.get(split.getInputFormatIndex());
                VertexReader<I, V, E> vertexReader = vertexInputFormat.createVertexReader(split.getSplit(), context);
                return new WrappedVertexReader<I, V, E>(vertexReader, vertexInputFormat.getConf()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
                        TaskAttemptContext taskAttemptContext = context;
                        synchronized (taskAttemptContext) {
                            super.initialize(inputSplit, context);
                        }
                    }
                };
            }
        }
        throw new IllegalStateException("createVertexReader: Got InputSplit which was not created by this class: " + inputSplit.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        JobContext jobContext = context;
        synchronized (jobContext) {
            return MultiInputUtils.getSplits(context, minSplitCountHint, this.vertexInputFormats);
        }
    }

    @Override
    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        MultiInputUtils.writeInputSplit(inputSplit, dataOutput, this.vertexInputFormats);
    }

    @Override
    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        return MultiInputUtils.readInputSplit(dataInput, this.vertexInputFormats);
    }
}

