/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.giraph.io.formats.multi.InputSplitWithInputFormatIndex;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;

public class MultiInputUtils {
    private MultiInputUtils() {
    }

    public static List<InputSplit> getSplits(JobContext context, int minSplitCountHint, List<? extends GiraphInputFormat> inputFormats) throws IOException, InterruptedException {
        ArrayList splits = Lists.newArrayList();
        for (int index = 0; index < inputFormats.size(); ++index) {
            List<InputSplit> inputFormatSplits = inputFormats.get(index).getSplits(context, minSplitCountHint);
            for (InputSplit split : inputFormatSplits) {
                splits.add(new InputSplitWithInputFormatIndex(split, index));
            }
        }
        return splits;
    }

    public static void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput, List<? extends GiraphInputFormat> inputFormats) throws IOException {
        if (!(inputSplit instanceof InputSplitWithInputFormatIndex)) {
            throw new IllegalStateException("writeInputSplit: Got InputSplit which was not created by multi input: " + inputSplit.getClass().getName());
        }
        InputSplitWithInputFormatIndex split = (InputSplitWithInputFormatIndex)inputSplit;
        int index = split.getInputFormatIndex();
        dataOutput.writeInt(index);
        inputFormats.get(index).writeInputSplit(split.getSplit(), dataOutput);
    }

    public static InputSplit readInputSplit(DataInput dataInput, List<? extends GiraphInputFormat> inputFormats) throws IOException, ClassNotFoundException {
        int index = dataInput.readInt();
        InputSplit split = inputFormats.get(index).readInputSplit(dataInput);
        return new InputSplitWithInputFormatIndex(split, index);
    }
}

