/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.formats.multi.EdgeInputFormatDescription;
import org.apache.giraph.io.formats.multi.InputSplitWithInputFormatIndex;
import org.apache.giraph.io.formats.multi.MultiInputUtils;
import org.apache.giraph.io.internal.WrappedEdgeReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class MultiEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    private List<EdgeInputFormat<I, E>> edgeInputFormats;

    @Override
    public void checkInputSpecs(Configuration conf) {
        for (EdgeInputFormat<I, E> edgeInputFormat : this.edgeInputFormats) {
            edgeInputFormat.checkInputSpecs(conf);
        }
    }

    @Override
    public void setConf(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        super.setConf(conf);
        this.edgeInputFormats = EdgeInputFormatDescription.createEdgeInputFormats(this.getConf());
        if (this.edgeInputFormats.isEmpty()) {
            throw new IllegalStateException("setConf: Using MultiEdgeInputFormat without specifying edge inputs");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EdgeReader<I, E> createEdgeReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
        if (inputSplit instanceof InputSplitWithInputFormatIndex) {
            TaskAttemptContext taskAttemptContext = context;
            synchronized (taskAttemptContext) {
                InputSplitWithInputFormatIndex split = (InputSplitWithInputFormatIndex)inputSplit;
                EdgeInputFormat<I, E> edgeInputFormat = this.edgeInputFormats.get(split.getInputFormatIndex());
                EdgeReader<I, E> edgeReader = edgeInputFormat.createEdgeReader(split.getSplit(), context);
                return new WrappedEdgeReader<I, E>(edgeReader, edgeInputFormat.getConf()){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
                        TaskAttemptContext taskAttemptContext = context;
                        synchronized (taskAttemptContext) {
                            super.initialize(inputSplit, context);
                        }
                    }
                };
            }
        }
        throw new IllegalStateException("createEdgeReader: Got InputSplit which was not created by this class: " + inputSplit.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        JobContext jobContext = context;
        synchronized (jobContext) {
            return MultiInputUtils.getSplits(context, minSplitCountHint, this.edgeInputFormats);
        }
    }

    @Override
    public void writeInputSplit(InputSplit inputSplit, DataOutput dataOutput) throws IOException {
        MultiInputUtils.writeInputSplit(inputSplit, dataOutput, this.edgeInputFormats);
    }

    @Override
    public InputSplit readInputSplit(DataInput dataInput) throws IOException, ClassNotFoundException {
        return MultiInputUtils.readInputSplit(dataInput, this.edgeInputFormats);
    }
}

