/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import com.google.common.collect.Maps;
import java.util.Iterator;
import java.util.Map;
import org.apache.giraph.io.GiraphInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class InputFormatDescription<IF extends GiraphInputFormat> {
    private Class<? extends IF> inputFormatClass;
    private final Map<String, String> parameters = Maps.newHashMap();

    public InputFormatDescription(Class<? extends IF> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public InputFormatDescription(String description) {
        try {
            JSONArray jsonArray = new JSONArray(description);
            this.inputFormatClass = Class.forName(jsonArray.getString(0));
            if (jsonArray.length() > 1) {
                this.addParameters(jsonArray.getJSONObject(1));
            }
        }
        catch (JSONException e) {
            throw new IllegalStateException("Failed to parse JSON " + description, e);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Couldn't find input format class from description " + description, e);
        }
    }

    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    public void addParameters(JSONObject parametersJson) {
        Iterator keys = parametersJson.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                this.addParameter(key, parametersJson.getString(key));
            }
            catch (JSONException e) {
                throw new IllegalStateException("addParameters: Failed to parse " + parametersJson, e);
            }
        }
    }

    public JSONArray toJsonArray() {
        JSONArray jsonArray = new JSONArray();
        jsonArray.put((Object)this.inputFormatClass.getName());
        JSONObject jsonParameters = new JSONObject();
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            try {
                jsonParameters.put(entry.getKey(), (Object)entry.getValue());
            }
            catch (JSONException e) {
                throw new IllegalStateException("toJsonArray: JSONException occurred while trying to process (" + entry.getKey() + ", " + entry.getValue() + ")", e);
            }
        }
        jsonArray.put((Object)jsonParameters);
        return jsonArray;
    }

    public Class<? extends IF> getInputFormatClass() {
        return this.inputFormatClass;
    }

    public void setInputFormatClass(Class<? extends IF> inputFormatClass) {
        this.inputFormatClass = inputFormatClass;
    }

    public void putParametersToConfiguration(Configuration conf) {
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            conf.set(entry.getKey(), entry.getValue());
        }
    }

    public String toString() {
        return this.toJsonArray().toString();
    }

    public static String toJsonString(Iterable<? extends InputFormatDescription> descriptions) {
        JSONArray jsonArray = new JSONArray();
        for (InputFormatDescription inputFormatDescription : descriptions) {
            jsonArray.put((Object)inputFormatDescription.toJsonArray());
        }
        return jsonArray.toString();
    }
}

