/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats.multi;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.conf.StrConfOption;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.formats.multi.InputFormatDescription;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.json.JSONArray;
import org.json.JSONException;

public class EdgeInputFormatDescription<I extends WritableComparable, E extends Writable>
extends InputFormatDescription<EdgeInputFormat<I, E>> {
    public static final StrConfOption EDGE_INPUT_FORMAT_DESCRIPTIONS = new StrConfOption("giraph.multiEdgeInput.descriptions", null, "EdgeInputFormats description - JSON array containing a JSON array for each edge input. Edge input JSON arrays contain one or two elements - first one is the name of edge input class, and second one is JSON object with all specific parameters for this edge input. For example: [[\"EIF1\",{\"p\":\"v1\"}],[\"EIF2\",{\"p\":\"v2\",\"q\":\"v\"}]]");

    public EdgeInputFormatDescription(Class<? extends EdgeInputFormat<I, E>> edgeInputFormatClass) {
        super(edgeInputFormatClass);
    }

    public EdgeInputFormatDescription(String description) {
        super(description);
    }

    private ImmutableClassesGiraphConfiguration<I, Writable, E> createConfigurationCopy(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        ImmutableClassesGiraphConfiguration confCopy = new ImmutableClassesGiraphConfiguration(conf);
        confCopy.setEdgeInputFormatClass(this.getInputFormatClass());
        this.putParametersToConfiguration(confCopy);
        return confCopy;
    }

    public static <I extends WritableComparable, E extends Writable> List<EdgeInputFormatDescription<I, E>> getEdgeInputFormatDescriptions(Configuration conf) {
        String edgeInputFormatDescriptions = EDGE_INPUT_FORMAT_DESCRIPTIONS.get(conf);
        if (edgeInputFormatDescriptions == null) {
            return Lists.newArrayList();
        }
        try {
            JSONArray inputFormatsJson = new JSONArray(edgeInputFormatDescriptions);
            ArrayList descriptions = Lists.newArrayListWithCapacity((int)inputFormatsJson.length());
            for (int i = 0; i < inputFormatsJson.length(); ++i) {
                descriptions.add(new EdgeInputFormatDescription<I, E>(inputFormatsJson.getString(i)));
            }
            return descriptions;
        }
        catch (JSONException e) {
            throw new IllegalStateException("getEdgeInputFormatDescriptions: JSONException occurred while trying to process " + edgeInputFormatDescriptions, e);
        }
    }

    public static <I extends WritableComparable, E extends Writable> List<EdgeInputFormat<I, E>> createEdgeInputFormats(ImmutableClassesGiraphConfiguration<I, Writable, E> conf) {
        List<EdgeInputFormatDescription<I, E>> descriptions = EdgeInputFormatDescription.getEdgeInputFormatDescriptions(conf);
        ArrayList edgeInputFormats = Lists.newArrayListWithCapacity((int)descriptions.size());
        for (EdgeInputFormatDescription<I, E> description : descriptions) {
            ImmutableClassesGiraphConfiguration<I, Writable, E> confCopy = super.createConfigurationCopy(conf);
            edgeInputFormats.add(confCopy.createWrappedEdgeInputFormat());
        }
        return edgeInputFormats;
    }
}

