/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.PseudoRandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class WattsStrogatzVertexInputFormat
extends VertexInputFormat<LongWritable, DoubleWritable, DoubleWritable> {
    private static final String AGGREGATE_VERTICES = "wattsStrogatz.aggregateVertices";
    private static final String EDGES_PER_VERTEX = "wattsStrogatz.edgesPerVertex";
    private static final String BETA = "wattsStrogatz.beta";
    private static final String SEED = "wattsStrogatz.seed";

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return PseudoRandomUtils.getSplits(minSplitCountHint);
    }

    @Override
    public VertexReader<LongWritable, DoubleWritable, DoubleWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new WattsStrogatzVertexReader();
    }

    private static class WattsStrogatzVertexReader
    extends VertexReader<LongWritable, DoubleWritable, DoubleWritable> {
        private float beta = 0.0f;
        private long aggregateVertices = 0L;
        private long startingVertexId = -1L;
        private long verticesRead = 0L;
        private long totalSplitVertices = -1L;
        private int edgesPerVertex = -1;
        private final LongSet destVertices = new LongOpenHashSet();
        private Random rnd;
        private ReusableEdge<LongWritable, DoubleWritable> reusableEdge = null;

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
            int seed;
            this.beta = this.getConf().getFloat(WattsStrogatzVertexInputFormat.BETA, 0.0f);
            this.aggregateVertices = this.getConf().getLong(WattsStrogatzVertexInputFormat.AGGREGATE_VERTICES, 0L);
            BspInputSplit bspInputSplit = (BspInputSplit)inputSplit;
            long extraVertices = this.aggregateVertices % (long)bspInputSplit.getNumSplits();
            this.totalSplitVertices = this.aggregateVertices / (long)bspInputSplit.getNumSplits();
            if ((long)bspInputSplit.getSplitIndex() < extraVertices) {
                ++this.totalSplitVertices;
            }
            this.startingVertexId = (long)bspInputSplit.getSplitIndex() * (this.aggregateVertices / (long)bspInputSplit.getNumSplits()) + Math.min((long)bspInputSplit.getSplitIndex(), extraVertices);
            this.edgesPerVertex = this.getConf().getInt(WattsStrogatzVertexInputFormat.EDGES_PER_VERTEX, 0);
            if (this.getConf().reuseEdgeObjects()) {
                this.reusableEdge = this.getConf().createReusableEdge();
            }
            this.rnd = (seed = this.getConf().getInt(WattsStrogatzVertexInputFormat.SEED, -1)) != -1 ? new Random(seed) : new Random();
        }

        @Override
        public boolean nextVertex() throws IOException, InterruptedException {
            return this.totalSplitVertices > this.verticesRead;
        }

        private long nextLong(long n) {
            long val;
            long bits;
            while ((bits = this.rnd.nextLong() << 1 >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
            }
            return val;
        }

        private long getRandomDestination() {
            long randomId;
            while (!this.destVertices.add(randomId = this.nextLong(this.aggregateVertices))) {
            }
            return randomId;
        }

        @Override
        public Vertex<LongWritable, DoubleWritable, DoubleWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex = this.getConf().createVertex();
            long vertexId = this.startingVertexId + this.verticesRead;
            OutEdges<Object, Object> edges = this.getConf().createOutEdges();
            edges.initialize(this.edgesPerVertex);
            this.destVertices.clear();
            this.destVertices.add(vertexId);
            long destVertexId = vertexId - (long)(this.edgesPerVertex / 2);
            if (destVertexId < 0L) {
                destVertexId = this.aggregateVertices + destVertexId;
            }
            for (int i = 0; i < this.edgesPerVertex + 1; ++i) {
                if (destVertexId != vertexId) {
                    Edge<Object, Object> edge = this.reusableEdge == null ? this.getConf().createEdge() : this.reusableEdge;
                    ((LongWritable)edge.getTargetVertexId()).set(this.rnd.nextFloat() < this.beta ? this.getRandomDestination() : destVertexId);
                    ((DoubleWritable)edge.getValue()).set(this.rnd.nextDouble());
                    edges.add(edge);
                }
                destVertexId = (destVertexId + 1L) % this.aggregateVertices;
            }
            vertex.initialize(new LongWritable(vertexId), new DoubleWritable(this.rnd.nextDouble()), edges);
            ++this.verticesRead;
            return vertex;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException {
            return (float)this.verticesRead * 100.0f / (float)this.totalSplitVertices;
        }
    }
}

