/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.io.VertexValueInputFormat;
import org.apache.giraph.io.VertexValueReader;
import org.apache.giraph.io.formats.GiraphTextInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TextVertexValueInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexValueInputFormat<I, V> {
    protected GiraphTextInputFormat textInputFormat = new GiraphTextInputFormat();

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.textInputFormat.getVertexSplits(context);
    }

    public abstract TextVertexValueReader createVertexValueReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected abstract class TextVertexValueReaderFromEachLineProcessed<T>
    extends TextVertexValueReader {
        private T processedLine;

        protected TextVertexValueReaderFromEachLineProcessed() {
            this.processedLine = null;
        }

        private T getProcessedLine() throws IOException, InterruptedException {
            if (this.processedLine == null) {
                this.processedLine = this.preprocessLine((Text)this.getRecordReader().getCurrentValue());
            }
            return this.processedLine;
        }

        @Override
        public I getCurrentVertexId() throws IOException, InterruptedException {
            return this.getId(this.getProcessedLine());
        }

        @Override
        public V getCurrentVertexValue() throws IOException, InterruptedException {
            return this.getValue(this.getProcessedLine());
        }

        @Override
        public final boolean nextVertex() throws IOException, InterruptedException {
            this.processedLine = null;
            return this.getRecordReader().nextKeyValue();
        }

        protected abstract T preprocessLine(Text var1) throws IOException;

        protected abstract I getId(T var1) throws IOException;

        protected abstract V getValue(T var1) throws IOException;
    }

    protected abstract class TextVertexValueReaderFromEachLine
    extends TextVertexValueReader {
        protected TextVertexValueReaderFromEachLine() {
        }

        @Override
        public final I getCurrentVertexId() throws IOException, InterruptedException {
            return this.getId((Text)this.getRecordReader().getCurrentValue());
        }

        @Override
        public final V getCurrentVertexValue() throws IOException, InterruptedException {
            return this.getValue((Text)this.getRecordReader().getCurrentValue());
        }

        @Override
        public final boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }

        protected abstract I getId(Text var1) throws IOException;

        protected abstract V getValue(Text var1) throws IOException;
    }

    protected abstract class TextVertexValueReader
    extends VertexValueReader<I, V> {
        private RecordReader<LongWritable, Text> lineRecordReader;
        private TaskAttemptContext context;

        protected TextVertexValueReader() {
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(inputSplit, context);
            this.context = context;
            this.lineRecordReader = this.createLineRecordReader(inputSplit, context);
            this.lineRecordReader.initialize(inputSplit, context);
        }

        protected RecordReader<LongWritable, Text> createLineRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            return TextVertexValueInputFormat.this.textInputFormat.createRecordReader(inputSplit, context);
        }

        @Override
        public void close() throws IOException {
            this.lineRecordReader.close();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.lineRecordReader.getProgress();
        }

        protected RecordReader<LongWritable, Text> getRecordReader() {
            return this.lineRecordReader;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

