/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.io.formats.GiraphTextOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TextVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    protected GiraphTextOutputFormat textOutputFormat = new GiraphTextOutputFormat(){

        @Override
        protected String getSubdir() {
            return GiraphConstants.VERTEX_OUTPUT_FORMAT_SUBDIR.get(TextVertexOutputFormat.this.getConf());
        }
    };

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.textOutputFormat.checkOutputSpecs(context);
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.textOutputFormat.getOutputCommitter(context);
    }

    public abstract TextVertexWriter createVertexWriter(TaskAttemptContext var1) throws IOException, InterruptedException;

    protected abstract class TextVertexWriterToEachLine
    extends TextVertexWriter {
        protected TextVertexWriterToEachLine() {
        }

        @Override
        public final void writeVertex(Vertex vertex) throws IOException, InterruptedException {
            this.getRecordWriter().write((Object)this.convertVertexToLine(vertex), null);
        }

        protected abstract Text convertVertexToLine(Vertex<I, V, E> var1) throws IOException;
    }

    protected abstract class TextVertexWriter
    extends VertexWriter<I, V, E> {
        private RecordWriter<Text, Text> lineRecordWriter;
        private TaskAttemptContext context;

        protected TextVertexWriter() {
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordWriter = this.createLineRecordWriter(context);
            this.context = context;
        }

        protected RecordWriter<Text, Text> createLineRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return TextVertexOutputFormat.this.textOutputFormat.getRecordWriter(context);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordWriter.close(context);
        }

        public RecordWriter<Text, Text> getRecordWriter() {
            return this.lineRecordWriter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

