/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.GiraphTextInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TextVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexInputFormat<I, V, E> {
    protected GiraphTextInputFormat textInputFormat = new GiraphTextInputFormat();

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.textInputFormat.getVertexSplits(context);
    }

    public abstract TextVertexReader createVertexReader(InputSplit var1, TaskAttemptContext var2) throws IOException;

    protected abstract class TextVertexReaderFromEachLineProcessedHandlingExceptions<T, X extends Throwable>
    extends TextVertexReader {
        protected TextVertexReaderFromEachLineProcessedHandlingExceptions() {
        }

        @Override
        public final boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }

        @Override
        public final Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            Vertex vertex;
            Text line = (Text)this.getRecordReader().getCurrentValue();
            T processed = null;
            try {
                processed = this.preprocessLine(line);
                vertex = this.getConf().createVertex();
                vertex.initialize(this.getId(processed), this.getValue(processed), this.getEdges(processed));
            }
            catch (IOException e) {
                throw e;
            }
            catch (Throwable t) {
                return this.handleException(line, processed, t);
            }
            return vertex;
        }

        protected abstract T preprocessLine(Text var1) throws X, IOException;

        protected abstract I getId(T var1) throws X, IOException;

        protected abstract V getValue(T var1) throws X, IOException;

        protected abstract Iterable<Edge<I, E>> getEdges(T var1) throws X, IOException;

        protected Vertex<I, V, E> handleException(Text line, T processed, X e) {
            throw new IllegalArgumentException((Throwable)e);
        }
    }

    protected abstract class TextVertexReaderFromEachLineProcessed<T>
    extends TextVertexReader {
        protected TextVertexReaderFromEachLineProcessed() {
        }

        @Override
        public final boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }

        @Override
        public final Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            Text line = (Text)this.getRecordReader().getCurrentValue();
            T processed = this.preprocessLine(line);
            Vertex vertex = this.getConf().createVertex();
            vertex.initialize(this.getId(processed), this.getValue(processed), this.getEdges(processed));
            return vertex;
        }

        protected abstract T preprocessLine(Text var1) throws IOException;

        protected abstract I getId(T var1) throws IOException;

        protected abstract V getValue(T var1) throws IOException;

        protected abstract Iterable<Edge<I, E>> getEdges(T var1) throws IOException;
    }

    protected abstract class TextVertexReaderFromEachLine
    extends TextVertexReader {
        protected TextVertexReaderFromEachLine() {
        }

        @Override
        public final Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            Text line = (Text)this.getRecordReader().getCurrentValue();
            Vertex vertex = this.getConf().createVertex();
            vertex.initialize(this.getId(line), this.getValue(line), this.getEdges(line));
            return vertex;
        }

        @Override
        public final boolean nextVertex() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }

        protected abstract I getId(Text var1) throws IOException;

        protected abstract V getValue(Text var1) throws IOException;

        protected abstract Iterable<Edge<I, E>> getEdges(Text var1) throws IOException;
    }

    protected abstract class TextVertexReader
    extends VertexReader<I, V, E> {
        private RecordReader<LongWritable, Text> lineRecordReader;
        private TaskAttemptContext context;

        protected TextVertexReader() {
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.context = context;
            this.lineRecordReader = this.createLineRecordReader(inputSplit, context);
            this.lineRecordReader.initialize(inputSplit, context);
        }

        protected RecordReader<LongWritable, Text> createLineRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            return TextVertexInputFormat.this.textInputFormat.createRecordReader(inputSplit, context);
        }

        @Override
        public void close() throws IOException {
            this.lineRecordReader.close();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.lineRecordReader.getProgress();
        }

        protected RecordReader<LongWritable, Text> getRecordReader() {
            return this.lineRecordReader;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

