/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.EdgeOutputFormat;
import org.apache.giraph.io.EdgeWriter;
import org.apache.giraph.io.formats.GiraphTextOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TextEdgeOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends EdgeOutputFormat<I, V, E> {
    protected GiraphTextOutputFormat textOutputFormat = new GiraphTextOutputFormat(){

        @Override
        protected String getSubdir() {
            return GiraphConstants.EDGE_OUTPUT_FORMAT_SUBDIR.get(TextEdgeOutputFormat.this.getConf());
        }
    };

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.textOutputFormat.checkOutputSpecs(context);
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.textOutputFormat.getOutputCommitter(context);
    }

    public abstract TextEdgeWriter createEdgeWriter(TaskAttemptContext var1) throws IOException, InterruptedException;

    protected abstract class TextEdgeWriterToEachLine<I extends WritableComparable, V extends Writable, E extends Writable>
    extends TextEdgeWriter<I, V, E> {
        protected TextEdgeWriterToEachLine() {
        }

        @Override
        public final void writeEdge(I sourceId, V sourceValue, Edge<I, E> edge) throws IOException, InterruptedException {
            this.getRecordWriter().write((Object)this.convertEdgeToLine(sourceId, sourceValue, edge), null);
        }

        protected abstract Text convertEdgeToLine(I var1, V var2, Edge<I, E> var3) throws IOException;
    }

    protected abstract class TextEdgeWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends EdgeWriter<I, V, E> {
        private RecordWriter<Text, Text> lineRecordWriter;
        private TaskAttemptContext context;

        protected TextEdgeWriter() {
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordWriter = this.createLineRecordWriter(context);
            this.context = context;
        }

        protected RecordWriter<Text, Text> createLineRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
            return TextEdgeOutputFormat.this.textOutputFormat.getRecordWriter(context);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.lineRecordWriter.close(context);
        }

        public RecordWriter<Text, Text> getRecordWriter() {
            return this.lineRecordWriter;
        }

        public TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

