/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.formats.GiraphTextInputFormat;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public abstract class TextEdgeInputFormat<I extends WritableComparable, E extends Writable>
extends EdgeInputFormat<I, E> {
    protected GiraphTextInputFormat textInputFormat = new GiraphTextInputFormat();

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.textInputFormat.getEdgeSplits(context);
    }

    protected abstract class TextEdgeReaderFromEachLineProcessed<T>
    extends TextEdgeReader {
        private T processedLine;

        protected TextEdgeReaderFromEachLineProcessed() {
        }

        @Override
        public I getCurrentSourceId() throws IOException, InterruptedException {
            T processed = this.processCurrentLine();
            return this.getSourceVertexId(processed);
        }

        @Override
        public final Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
            T processed = this.processCurrentLine();
            Object targetVertexId = this.getTargetVertexId(processed);
            Object edgeValue = this.getValue(processed);
            return EdgeFactory.create(targetVertexId, edgeValue);
        }

        private T processCurrentLine() throws IOException, InterruptedException {
            if (this.processedLine == null) {
                Text line = (Text)this.getRecordReader().getCurrentValue();
                this.processedLine = this.preprocessLine(line);
            }
            return this.processedLine;
        }

        @Override
        public final boolean nextEdge() throws IOException, InterruptedException {
            this.processedLine = null;
            return this.getRecordReader().nextKeyValue();
        }

        protected abstract T preprocessLine(Text var1) throws IOException;

        protected abstract I getTargetVertexId(T var1) throws IOException;

        protected abstract I getSourceVertexId(T var1) throws IOException;

        protected abstract E getValue(T var1) throws IOException;
    }

    protected abstract class TextEdgeReaderFromEachLine
    extends TextEdgeReader {
        protected TextEdgeReaderFromEachLine() {
        }

        @Override
        public final I getCurrentSourceId() throws IOException, InterruptedException {
            Text line = (Text)this.getRecordReader().getCurrentValue();
            return this.getSourceVertexId(line);
        }

        @Override
        public final Edge<I, E> getCurrentEdge() throws IOException, InterruptedException {
            Text line = (Text)this.getRecordReader().getCurrentValue();
            Object targetVertexId = this.getTargetVertexId(line);
            Object edgeValue = this.getValue(line);
            return EdgeFactory.create(targetVertexId, edgeValue);
        }

        @Override
        public final boolean nextEdge() throws IOException, InterruptedException {
            return this.getRecordReader().nextKeyValue();
        }

        protected abstract I getSourceVertexId(Text var1) throws IOException;

        protected abstract I getTargetVertexId(Text var1) throws IOException;

        protected abstract E getValue(Text var1) throws IOException;
    }

    protected abstract class TextEdgeReader
    extends EdgeReader<I, E> {
        private RecordReader<LongWritable, Text> lineRecordReader;
        private TaskAttemptContext context;

        protected TextEdgeReader() {
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.context = context;
            this.lineRecordReader = this.createLineRecordReader(inputSplit, context);
            this.lineRecordReader.initialize(inputSplit, context);
        }

        protected RecordReader<LongWritable, Text> createLineRecordReader(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            return TextEdgeInputFormat.this.textInputFormat.createRecordReader(inputSplit, context);
        }

        @Override
        public void close() throws IOException {
            this.lineRecordReader.close();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.lineRecordReader.getProgress();
        }

        protected RecordReader<LongWritable, Text> getRecordReader() {
            return this.lineRecordReader;
        }

        protected TaskAttemptContext getContext() {
            return this.context;
        }
    }
}

