/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.conf.GiraphConstants;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.io.formats.TextEdgeOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class SrcIdDstIdEdgeValueTextOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextEdgeOutputFormat<I, V, E> {
    @Override
    public TextEdgeOutputFormat.TextEdgeWriter createEdgeWriter(TaskAttemptContext context) {
        return new SrcIdDstIdEdgeValueEdgeWriter();
    }

    protected class SrcIdDstIdEdgeValueEdgeWriter<I extends WritableComparable, V extends Writable, E extends Writable>
    extends TextEdgeOutputFormat.TextEdgeWriterToEachLine<I, V, E> {
        private String delimiter;
        private boolean reverseOutput;

        protected SrcIdDstIdEdgeValueEdgeWriter() {
            super(SrcIdDstIdEdgeValueTextOutputFormat.this);
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(context);
            this.delimiter = GiraphConstants.GIRAPH_TEXT_OUTPUT_FORMAT_SEPARATOR.get(this.getConf());
            this.reverseOutput = GiraphConstants.GIRAPH_TEXT_OUTPUT_FORMAT_REVERSE.get(this.getConf());
        }

        @Override
        protected Text convertEdgeToLine(I sourceId, V sourceValue, Edge<I, E> edge) throws IOException {
            StringBuilder msg = new StringBuilder();
            if (this.reverseOutput) {
                msg.append(edge.getValue().toString());
                msg.append(this.delimiter);
                msg.append(edge.getTargetVertexId().toString());
                msg.append(this.delimiter);
                msg.append(sourceId.toString());
            } else {
                msg.append(sourceId.toString());
                msg.append(this.delimiter);
                msg.append(edge.getTargetVertexId().toString());
                msg.append(this.delimiter);
                msg.append(edge.getValue().toString());
            }
            return new Text(msg.toString());
        }
    }
}

