/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;

public abstract class SequenceFileVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable, OK extends Writable, OV extends Writable>
extends VertexOutputFormat<I, V, E> {
    private SequenceFileOutputFormat<OK, OV> sequenceFileOutputFormat = new SequenceFileOutputFormat();

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
        this.sequenceFileOutputFormat.checkOutputSpecs(context);
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return this.sequenceFileOutputFormat.getOutputCommitter(context);
    }

    @Override
    public VertexWriter createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new SequenceFileVertexWriter();
    }

    protected abstract OK convertToSequenceFileKey(I var1);

    protected abstract OV convertToSequenceFileValue(V var1);

    private class SequenceFileVertexWriter
    extends VertexWriter<I, V, E> {
        private RecordWriter<OK, OV> recordWriter;

        private SequenceFileVertexWriter() {
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            this.recordWriter = SequenceFileVertexOutputFormat.this.sequenceFileOutputFormat.getRecordWriter(context);
        }

        @Override
        public final void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
            Object outKey = SequenceFileVertexOutputFormat.this.convertToSequenceFileKey(vertex.getId());
            Object outValue = SequenceFileVertexOutputFormat.this.convertToSequenceFileValue(vertex.getValue());
            this.recordWriter.write(outKey, outValue);
        }

        @Override
        public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            this.recordWriter.close(context);
        }
    }
}

