/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.List;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;

public class SequenceFileVertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable, X extends Vertex<I, V, E>>
extends VertexInputFormat<I, V, E> {
    protected SequenceFileInputFormat<I, X> sequenceFileInputFormat = new SequenceFileInputFormat();

    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return this.sequenceFileInputFormat.getSplits(context);
    }

    @Override
    public VertexReader<I, V, E> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new SequenceFileVertexReader(this.sequenceFileInputFormat.createRecordReader(split, context));
    }

    public static class SequenceFileVertexReader<I extends WritableComparable, V extends Writable, E extends Writable, X extends Vertex<I, V, E>>
    extends VertexReader<I, V, E> {
        private final RecordReader<I, X> recordReader;

        public SequenceFileVertexReader(RecordReader<I, X> recordReader) {
            this.recordReader = recordReader;
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            this.recordReader.initialize(inputSplit, context);
        }

        @Override
        public boolean nextVertex() throws IOException, InterruptedException {
            return this.recordReader.nextKeyValue();
        }

        @Override
        public Vertex<I, V, E> getCurrentVertex() throws IOException, InterruptedException {
            return (Vertex)this.recordReader.getCurrentValue();
        }

        @Override
        public void close() throws IOException {
            this.recordReader.close();
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return this.recordReader.getProgress();
        }
    }
}

