/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.PseudoRandomLocalEdgesHelper;
import org.apache.giraph.io.formats.PseudoRandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class PseudoRandomVertexInputFormat
extends VertexInputFormat<LongWritable, DoubleWritable, DoubleWritable> {
    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return PseudoRandomUtils.getSplits(minSplitCountHint);
    }

    @Override
    public VertexReader<LongWritable, DoubleWritable, DoubleWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new PseudoRandomVertexReader();
    }

    private static class PseudoRandomVertexReader
    extends VertexReader<LongWritable, DoubleWritable, DoubleWritable> {
        private static final Logger LOG = Logger.getLogger(PseudoRandomVertexReader.class);
        private long startingVertexId = -1L;
        private long verticesRead = 0L;
        private long totalSplitVertices = -1L;
        private long aggregateVertices = -1L;
        private int edgesPerVertex = -1;
        private BspInputSplit bspInputSplit;
        private PseudoRandomLocalEdgesHelper localEdgesHelper;

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
            long extraVertices;
            this.aggregateVertices = this.getConf().getLong("giraph.pseudoRandomInputFormat.aggregateVertices", 0L);
            if (this.aggregateVertices <= 0L) {
                throw new IllegalArgumentException("giraph.pseudoRandomInputFormat.aggregateVertices <= 0");
            }
            if (inputSplit instanceof BspInputSplit) {
                this.bspInputSplit = (BspInputSplit)inputSplit;
                extraVertices = this.aggregateVertices % (long)this.bspInputSplit.getNumSplits();
                this.totalSplitVertices = this.aggregateVertices / (long)this.bspInputSplit.getNumSplits();
                if ((long)this.bspInputSplit.getSplitIndex() < extraVertices) {
                    ++this.totalSplitVertices;
                }
            } else {
                throw new IllegalArgumentException("initialize: Got " + inputSplit.getClass() + " instead of " + BspInputSplit.class);
            }
            this.startingVertexId = (long)this.bspInputSplit.getSplitIndex() * (this.aggregateVertices / (long)this.bspInputSplit.getNumSplits()) + Math.min((long)this.bspInputSplit.getSplitIndex(), extraVertices);
            this.edgesPerVertex = this.getConf().getInt("giraph.pseudoRandomInputFormat.edgesPerVertex", 0);
            if (this.edgesPerVertex <= 0) {
                throw new IllegalArgumentException("giraph.pseudoRandomInputFormat.edgesPerVertex <= 0");
            }
            float minLocalEdgesRatio = this.getConf().getFloat("giraph.pseudoRandomInputFormat.localEdgesMinRatio", 0.0f);
            this.localEdgesHelper = new PseudoRandomLocalEdgesHelper(this.aggregateVertices, minLocalEdgesRatio, this.getConf());
        }

        @Override
        public boolean nextVertex() throws IOException, InterruptedException {
            return this.totalSplitVertices > this.verticesRead;
        }

        @Override
        public Vertex<LongWritable, DoubleWritable, DoubleWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex<LongWritable, DoubleWritable, DoubleWritable> vertex = this.getConf().createVertex();
            long vertexId = this.startingVertexId + this.verticesRead;
            Random rand = new Random(vertexId);
            DoubleWritable vertexValue = new DoubleWritable(rand.nextDouble());
            OutEdges<LongWritable, DoubleWritable> edges = this.getConf().createAndInitializeOutEdges(this.edgesPerVertex);
            HashSet destVertices = Sets.newHashSet();
            for (long i = 0L; i < (long)this.edgesPerVertex; ++i) {
                LongWritable destVertexId = new LongWritable();
                do {
                    destVertexId.set(this.localEdgesHelper.generateDestVertex(vertexId, rand));
                } while (destVertices.contains(destVertexId));
                edges.add(EdgeFactory.create(destVertexId, new DoubleWritable(rand.nextDouble())));
                destVertices.add(destVertexId);
            }
            vertex.initialize(new LongWritable(vertexId), vertexValue, edges);
            ++this.verticesRead;
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("next: Return vertexId=" + vertex.getId().get() + ", vertexValue=" + vertex.getValue() + ", edges=" + vertex.getEdges()));
            }
            return vertex;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException {
            return (float)this.verticesRead * 100.0f / (float)this.totalSplitVertices;
        }
    }
}

