/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionUtils;
import org.apache.giraph.partition.SimpleLongRangePartitionerFactory;
import org.apache.giraph.worker.WorkerInfo;

public class PseudoRandomLocalEdgesHelper {
    private float minLocalEdgesRatio;
    private boolean usingRangePartitioner;
    private long numVertices;
    private int numPartitions;
    private long partitionSize;

    public PseudoRandomLocalEdgesHelper(long numVertices, float minLocalEdgesRatio, ImmutableClassesGiraphConfiguration conf) {
        this.minLocalEdgesRatio = minLocalEdgesRatio;
        this.numVertices = numVertices;
        this.usingRangePartitioner = SimpleLongRangePartitionerFactory.class.isAssignableFrom(conf.getGraphPartitionerClass());
        int numWorkers = conf.getMaxWorkers();
        List<WorkerInfo> workerInfos = Collections.nCopies(numWorkers, new WorkerInfo());
        this.numPartitions = PartitionUtils.computePartitionCount(workerInfos, numWorkers, conf);
        this.partitionSize = numVertices / (long)this.numPartitions;
    }

    public long generateDestVertex(long sourceVertexId, Random rand) {
        long destVertexId;
        if (rand.nextFloat() < this.minLocalEdgesRatio) {
            if (this.usingRangePartitioner) {
                int partitionId = Math.min(this.numPartitions - 1, (int)(sourceVertexId / this.partitionSize));
                destVertexId = (long)partitionId * this.partitionSize + Math.abs(rand.nextLong()) % this.partitionSize;
            } else {
                int partitionId = (int)sourceVertexId % this.numPartitions;
                destVertexId = (long)partitionId + (long)this.numPartitions * (Math.abs(rand.nextLong()) % this.partitionSize);
            }
        } else {
            destVertexId = Math.abs(rand.nextLong()) % this.numVertices;
        }
        return destVertexId;
    }
}

