/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.OutEdges;
import org.apache.giraph.edge.ReusableEdge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexInputFormat;
import org.apache.giraph.io.VertexReader;
import org.apache.giraph.io.formats.PseudoRandomIntNullLocalEdgesHelper;
import org.apache.giraph.io.formats.PseudoRandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class PseudoRandomIntNullVertexInputFormat
extends VertexInputFormat<IntWritable, FloatWritable, NullWritable> {
    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return PseudoRandomUtils.getSplits(minSplitCountHint);
    }

    @Override
    public VertexReader<IntWritable, FloatWritable, NullWritable> createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new PseudoRandomVertexReader();
    }

    private static class PseudoRandomVertexReader
    extends VertexReader<IntWritable, FloatWritable, NullWritable> {
        private int startingVertexId = -1;
        private int verticesRead = 0;
        private int totalSplitVertices = -1;
        private int edgesPerVertex = -1;
        private final IntSet destVertices = new IntOpenHashSet();
        private ReusableEdge<IntWritable, NullWritable> reusableEdge = null;
        private PseudoRandomIntNullLocalEdgesHelper localEdgesHelper;
        private Random rand;

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException {
            int aggregateVertices = this.getConf().getInt("giraph.pseudoRandomInputFormat.aggregateVertices", 0);
            BspInputSplit bspInputSplit = (BspInputSplit)inputSplit;
            int extraVertices = aggregateVertices % bspInputSplit.getNumSplits();
            this.totalSplitVertices = aggregateVertices / bspInputSplit.getNumSplits();
            if (bspInputSplit.getSplitIndex() < extraVertices) {
                ++this.totalSplitVertices;
            }
            this.startingVertexId = bspInputSplit.getSplitIndex() * (aggregateVertices / bspInputSplit.getNumSplits()) + Math.min(bspInputSplit.getSplitIndex(), extraVertices);
            this.edgesPerVertex = this.getConf().getInt("giraph.pseudoRandomInputFormat.edgesPerVertex", 0);
            this.rand = new Random(bspInputSplit.getSplitIndex());
            if (this.getConf().reuseEdgeObjects()) {
                this.reusableEdge = this.getConf().createReusableEdge();
            }
            this.localEdgesHelper = new PseudoRandomIntNullLocalEdgesHelper(aggregateVertices, this.getConf());
        }

        @Override
        public boolean nextVertex() throws IOException, InterruptedException {
            return this.totalSplitVertices > this.verticesRead;
        }

        @Override
        public Vertex<IntWritable, FloatWritable, NullWritable> getCurrentVertex() throws IOException, InterruptedException {
            Vertex<IntWritable, FloatWritable, NullWritable> vertex = this.getConf().createVertex();
            int vertexId = this.startingVertexId + this.verticesRead;
            OutEdges<Object, Object> edges = this.getConf().createOutEdges();
            edges.initialize(this.edgesPerVertex);
            this.destVertices.clear();
            for (int i = 0; i < this.edgesPerVertex; ++i) {
                int destVertexId;
                while (!this.destVertices.add(destVertexId = this.localEdgesHelper.generateDestVertex(vertexId, this.rand))) {
                }
                Edge<Object, Object> edge = this.reusableEdge == null ? this.getConf().createEdge() : this.reusableEdge;
                ((IntWritable)edge.getTargetVertexId()).set(destVertexId);
                edges.add(edge);
            }
            vertex.initialize(new IntWritable(vertexId), new FloatWritable(1.0f), edges);
            ++this.verticesRead;
            return vertex;
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException {
            return (float)this.verticesRead * 100.0f / (float)this.totalSplitVertices;
        }
    }
}

