/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.giraph.conf.ImmutableClassesGiraphConfiguration;
import org.apache.giraph.partition.PartitionUtils;
import org.apache.giraph.worker.WorkerInfo;

public class PseudoRandomIntNullLocalEdgesHelper {
    private float minLocalEdgesRatio;
    private int numVertices;
    private int numPartitions;
    private int partitionSize;

    public PseudoRandomIntNullLocalEdgesHelper(int numVertices, ImmutableClassesGiraphConfiguration conf) {
        this.minLocalEdgesRatio = conf.getFloat("giraph.pseudoRandomInputFormat.localEdgesMinRatio", 0.0f);
        this.numVertices = numVertices;
        int numWorkers = conf.getMaxWorkers();
        List<WorkerInfo> workerInfos = Collections.nCopies(numWorkers, new WorkerInfo());
        this.numPartitions = PartitionUtils.computePartitionCount(workerInfos, numWorkers, conf);
        this.partitionSize = numVertices / this.numPartitions;
    }

    public int generateDestVertex(int sourceVertexId, Random rand) {
        if (rand.nextFloat() < this.minLocalEdgesRatio) {
            int partitionId = sourceVertexId % this.numPartitions;
            return partitionId + this.numPartitions * rand.nextInt(this.partitionSize);
        }
        return rand.nextInt(this.numVertices);
    }
}

