/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import java.util.Set;
import org.apache.giraph.bsp.BspInputSplit;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.EdgeInputFormat;
import org.apache.giraph.io.EdgeReader;
import org.apache.giraph.io.formats.PseudoRandomLocalEdgesHelper;
import org.apache.giraph.io.formats.PseudoRandomUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.log4j.Logger;

public class PseudoRandomEdgeInputFormat
extends EdgeInputFormat<LongWritable, DoubleWritable> {
    @Override
    public void checkInputSpecs(Configuration conf) {
    }

    @Override
    public final List<InputSplit> getSplits(JobContext context, int minSplitCountHint) throws IOException, InterruptedException {
        return PseudoRandomUtils.getSplits(minSplitCountHint);
    }

    @Override
    public EdgeReader<LongWritable, DoubleWritable> createEdgeReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new PseudoRandomEdgeReader();
    }

    private static class PseudoRandomEdgeReader
    extends EdgeReader<LongWritable, DoubleWritable> {
        private static final Logger LOG = Logger.getLogger(PseudoRandomEdgeReader.class);
        private long startingVertexId = -1L;
        private long verticesRead = 0L;
        private long totalSplitVertices = -1L;
        private LongWritable currentVertexId = new LongWritable(-1L);
        private int currentOutEdgesRead = 0;
        private Set<LongWritable> currentVertexDestVertices = Sets.newHashSet();
        private Random random = new Random();
        private long aggregateVertices = -1L;
        private int edgesPerVertex = -1;
        private BspInputSplit bspInputSplit;
        private PseudoRandomLocalEdgesHelper localEdgesHelper;

        private PseudoRandomEdgeReader() {
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            long extraVertices;
            this.aggregateVertices = this.getConf().getLong("giraph.pseudoRandomInputFormat.aggregateVertices", 0L);
            if (this.aggregateVertices <= 0L) {
                throw new IllegalArgumentException("giraph.pseudoRandomInputFormat.aggregateVertices <= 0");
            }
            if (inputSplit instanceof BspInputSplit) {
                this.bspInputSplit = (BspInputSplit)inputSplit;
                extraVertices = this.aggregateVertices % (long)this.bspInputSplit.getNumSplits();
                this.totalSplitVertices = this.aggregateVertices / (long)this.bspInputSplit.getNumSplits();
                if ((long)this.bspInputSplit.getSplitIndex() < extraVertices) {
                    ++this.totalSplitVertices;
                }
            } else {
                throw new IllegalArgumentException("initialize: Got " + inputSplit.getClass() + " instead of " + BspInputSplit.class);
            }
            this.startingVertexId = (long)this.bspInputSplit.getSplitIndex() * (this.aggregateVertices / (long)this.bspInputSplit.getNumSplits()) + Math.min((long)this.bspInputSplit.getSplitIndex(), extraVertices);
            this.edgesPerVertex = this.getConf().getInt("giraph.pseudoRandomInputFormat.edgesPerVertex", 0);
            if (this.edgesPerVertex <= 0) {
                throw new IllegalArgumentException("giraph.pseudoRandomInputFormat.edgesPerVertex <= 0");
            }
            float minLocalEdgesRatio = this.getConf().getFloat("giraph.pseudoRandomInputFormat.localEdgesMinRatio", 0.0f);
            this.localEdgesHelper = new PseudoRandomLocalEdgesHelper(this.aggregateVertices, minLocalEdgesRatio, this.getConf());
        }

        @Override
        public boolean nextEdge() throws IOException, InterruptedException {
            return this.totalSplitVertices > this.verticesRead + 1L || this.totalSplitVertices == this.verticesRead + 1L && this.edgesPerVertex > this.currentOutEdgesRead;
        }

        @Override
        public LongWritable getCurrentSourceId() throws IOException, InterruptedException {
            if (this.currentOutEdgesRead == this.edgesPerVertex) {
                ++this.verticesRead;
                this.currentVertexId = new LongWritable(-1L);
            }
            if (this.currentVertexId.get() == -1L) {
                this.currentVertexId.set(this.startingVertexId + this.verticesRead);
                this.currentOutEdgesRead = 0;
                this.random.setSeed(this.currentVertexId.get());
                this.currentVertexDestVertices.clear();
            }
            return this.currentVertexId;
        }

        @Override
        public Edge<LongWritable, DoubleWritable> getCurrentEdge() throws IOException, InterruptedException {
            LongWritable destVertexId = new LongWritable();
            do {
                destVertexId.set(this.localEdgesHelper.generateDestVertex(this.currentVertexId.get(), this.random));
            } while (this.currentVertexDestVertices.contains(destVertexId));
            ++this.currentOutEdgesRead;
            this.currentVertexDestVertices.add(destVertexId);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("getCurrentEdge: Return edge (" + this.currentVertexId + ", " + "" + destVertexId + ")"));
            }
            return EdgeFactory.create(destVertexId, new DoubleWritable(this.random.nextDouble()));
        }

        @Override
        public void close() throws IOException {
        }

        @Override
        public float getProgress() throws IOException, InterruptedException {
            return (float)(this.verticesRead * (long)this.edgesPerVertex + (long)this.currentOutEdgesRead) * 100.0f / (float)(this.totalSplitVertices * (long)this.edgesPerVertex);
        }
    }
}

