/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONArray;
import org.json.JSONException;

public class JsonLongDoubleFloatDoubleVertexOutputFormat
extends TextVertexOutputFormat<LongWritable, DoubleWritable, FloatWritable> {
    @Override
    public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) {
        return new JsonLongDoubleFloatDoubleVertexWriter();
    }

    private class JsonLongDoubleFloatDoubleVertexWriter
    extends TextVertexOutputFormat.TextVertexWriterToEachLine {
        private JsonLongDoubleFloatDoubleVertexWriter() {
            super(JsonLongDoubleFloatDoubleVertexOutputFormat.this);
        }

        public Text convertVertexToLine(Vertex<LongWritable, DoubleWritable, FloatWritable> vertex) throws IOException {
            JSONArray jsonVertex = new JSONArray();
            try {
                jsonVertex.put(vertex.getId().get());
                jsonVertex.put(vertex.getValue().get());
                JSONArray jsonEdgeArray = new JSONArray();
                for (Edge<LongWritable, FloatWritable> edge : vertex.getEdges()) {
                    JSONArray jsonEdge = new JSONArray();
                    jsonEdge.put(edge.getTargetVertexId().get());
                    jsonEdge.put((double)edge.getValue().get());
                    jsonEdgeArray.put((Object)jsonEdge);
                }
                jsonVertex.put((Object)jsonEdgeArray);
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("writeVertex: Couldn't write vertex " + vertex);
            }
            return new Text(jsonVertex.toString());
        }
    }
}

