/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import net.iharder.Base64;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonBase64VertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextVertexOutputFormat<I, V, E> {
    @Override
    public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) {
        return new JsonBase64VertexWriter();
    }

    protected class JsonBase64VertexWriter
    extends TextVertexOutputFormat.TextVertexWriterToEachLine {
        protected JsonBase64VertexWriter() {
            super(JsonBase64VertexOutputFormat.this);
        }

        @Override
        protected Text convertVertexToLine(Vertex<I, V, E> vertex) throws IOException {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            DataOutputStream output = new DataOutputStream(outputStream);
            JSONObject vertexObject = new JSONObject();
            vertex.getId().write((DataOutput)output);
            try {
                vertexObject.put("vertexId", (Object)Base64.encodeBytes((byte[])outputStream.toByteArray()));
            }
            catch (JSONException e) {
                throw new IllegalStateException("writerVertex: Failed to insert vertex id", e);
            }
            outputStream.reset();
            vertex.getValue().write((DataOutput)output);
            try {
                vertexObject.put("vertexValue", (Object)Base64.encodeBytes((byte[])outputStream.toByteArray()));
            }
            catch (JSONException e) {
                throw new IllegalStateException("writerVertex: Failed to insert vertex value", e);
            }
            JSONArray edgeArray = new JSONArray();
            for (Edge edge : vertex.getEdges()) {
                outputStream.reset();
                edge.getTargetVertexId().write((DataOutput)output);
                edge.getValue().write((DataOutput)output);
                edgeArray.put((Object)Base64.encodeBytes((byte[])outputStream.toByteArray()));
            }
            try {
                vertexObject.put("edgeArray", (Object)edgeArray);
            }
            catch (JSONException e) {
                throw new IllegalStateException("writerVertex: Failed to insert edge array", e);
            }
            return new Text(vertexObject.toString());
        }
    }
}

