/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import net.iharder.Base64;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class JsonBase64VertexInputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextVertexInputFormat<I, V, E> {
    @Override
    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) {
        return new JsonBase64VertexReader();
    }

    protected class JsonBase64VertexReader
    extends TextVertexInputFormat.TextVertexReaderFromEachLineProcessed<JSONObject> {
        protected JsonBase64VertexReader() {
            super(JsonBase64VertexInputFormat.this);
        }

        @Override
        public void initialize(InputSplit inputSplit, TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(inputSplit, context);
        }

        @Override
        protected JSONObject preprocessLine(Text line) {
            try {
                return new JSONObject(line.toString());
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("next: Failed to get the vertex", e);
            }
        }

        @Override
        protected I getId(JSONObject vertexObject) throws IOException {
            try {
                byte[] decodedWritable = Base64.decode((String)vertexObject.getString("vertexId"));
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(decodedWritable));
                Object vertexId = this.getConf().createVertexId();
                vertexId.readFields((DataInput)input);
                return vertexId;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("next: Failed to get vertex id", e);
            }
        }

        @Override
        protected V getValue(JSONObject vertexObject) throws IOException {
            try {
                byte[] decodedWritable = Base64.decode((String)vertexObject.getString("vertexValue"));
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(decodedWritable));
                Object vertexValue = this.getConf().createVertexValue();
                vertexValue.readFields((DataInput)input);
                return vertexValue;
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("next: Failed to get vertex value", e);
            }
        }

        @Override
        protected Iterable<Edge<I, E>> getEdges(JSONObject vertexObject) throws IOException {
            JSONArray edgeArray = null;
            try {
                edgeArray = vertexObject.getJSONArray("edgeArray");
            }
            catch (JSONException e) {
                throw new IllegalArgumentException("next: Failed to get edge array", e);
            }
            ArrayList edges = Lists.newArrayListWithCapacity((int)edgeArray.length());
            for (int i = 0; i < edgeArray.length(); ++i) {
                byte[] decodedWritable;
                try {
                    decodedWritable = Base64.decode((String)edgeArray.getString(i));
                }
                catch (JSONException e) {
                    throw new IllegalArgumentException("next: Failed to get edge value", e);
                }
                DataInputStream input = new DataInputStream(new ByteArrayInputStream(decodedWritable));
                Object targetVertexId = this.getConf().createVertexId();
                targetVertexId.readFields((DataInput)input);
                Object edgeValue = this.getConf().createEdgeValue();
                edgeValue.readFields((DataInput)input);
                edges.add(EdgeFactory.create(targetVertexId, edgeValue));
            }
            return edges;
        }
    }
}

