/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import java.util.regex.Pattern;
import org.apache.giraph.io.formats.TextVertexValueInputFormat;
import org.apache.giraph.utils.IntPair;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class IntIntTextVertexValueInputFormat<E extends Writable>
extends TextVertexValueInputFormat<IntWritable, IntWritable, E> {
    private static final Pattern SEPARATOR = Pattern.compile("[\t ]");

    @Override
    public TextVertexValueInputFormat.TextVertexValueReader createVertexValueReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new IntIntTextVertexValueReader();
    }

    public class IntIntTextVertexValueReader
    extends TextVertexValueInputFormat.TextVertexValueReaderFromEachLineProcessed<IntPair> {
        public IntIntTextVertexValueReader() {
            super(IntIntTextVertexValueInputFormat.this);
        }

        @Override
        protected IntPair preprocessLine(Text line) throws IOException {
            String[] tokens = SEPARATOR.split(line.toString());
            return new IntPair(Integer.valueOf(tokens[0]), Integer.valueOf(tokens[1]));
        }

        @Override
        protected IntWritable getId(IntPair data) throws IOException {
            return new IntWritable(data.getFirst());
        }

        @Override
        protected IntWritable getValue(IntPair data) throws IOException {
            return new IntWritable(data.getSecond());
        }
    }
}

