/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Pattern;
import org.apache.giraph.edge.Edge;
import org.apache.giraph.edge.EdgeFactory;
import org.apache.giraph.io.formats.TextVertexInputFormat;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class IntIntNullTextVertexInputFormat
extends TextVertexInputFormat<IntWritable, IntWritable, NullWritable> {
    private static final Pattern SEPARATOR = Pattern.compile("[\t ]");

    @Override
    public TextVertexInputFormat.TextVertexReader createVertexReader(InputSplit split, TaskAttemptContext context) throws IOException {
        return new IntIntNullVertexReader();
    }

    public class IntIntNullVertexReader
    extends TextVertexInputFormat.TextVertexReaderFromEachLineProcessed<String[]> {
        private IntWritable id;
        private IntWritable value;

        public IntIntNullVertexReader() {
            super(IntIntNullTextVertexInputFormat.this);
        }

        @Override
        protected String[] preprocessLine(Text line) throws IOException {
            String[] tokens = SEPARATOR.split(line.toString());
            this.id = new IntWritable(Integer.parseInt(tokens[0]));
            this.value = new IntWritable(Integer.parseInt(tokens[1]));
            return tokens;
        }

        @Override
        protected IntWritable getId(String[] tokens) throws IOException {
            return this.id;
        }

        @Override
        protected IntWritable getValue(String[] tokens) throws IOException {
            return this.value;
        }

        @Override
        protected Iterable<Edge<IntWritable, NullWritable>> getEdges(String[] tokens) throws IOException {
            ArrayList edges = Lists.newArrayListWithCapacity((int)(tokens.length - 2));
            for (int n = 2; n < tokens.length; ++n) {
                edges.add(EdgeFactory.create(new IntWritable(Integer.parseInt(tokens[n]))));
            }
            return edges;
        }
    }
}

