/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.bsp.ImmutableOutputCommitter;
import org.apache.giraph.conf.GiraphConfiguration;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.VertexOutputFormat;
import org.apache.giraph.io.VertexWriter;
import org.apache.giraph.utils.TestGraph;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.OutputCommitter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class InMemoryVertexOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends VertexOutputFormat<I, V, E> {
    private static TestGraph OUTPUT_GRAPH;

    public static void initializeOutputGraph(GiraphConfiguration conf) {
        OUTPUT_GRAPH = new TestGraph(conf);
    }

    public static <I extends WritableComparable, V extends Writable, E extends Writable> TestGraph<I, V, E> getOutputGraph() {
        return OUTPUT_GRAPH;
    }

    @Override
    public VertexWriter<I, V, E> createVertexWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new VertexWriter<I, V, E>(){

            @Override
            public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            }

            @Override
            public void close(TaskAttemptContext context) throws IOException, InterruptedException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void writeVertex(Vertex<I, V, E> vertex) throws IOException, InterruptedException {
                TestGraph testGraph = OUTPUT_GRAPH;
                synchronized (testGraph) {
                    OUTPUT_GRAPH.addVertex(vertex);
                }
            }
        };
    }

    @Override
    public void checkOutputSpecs(JobContext context) throws IOException, InterruptedException {
    }

    @Override
    public OutputCommitter getOutputCommitter(TaskAttemptContext context) throws IOException, InterruptedException {
        return new ImmutableOutputCommitter();
    }
}

