/*
 * Decompiled with CFR 0.152.
 */
package org.apache.giraph.io.formats;

import java.io.IOException;
import org.apache.giraph.graph.Vertex;
import org.apache.giraph.io.formats.TextVertexOutputFormat;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapreduce.TaskAttemptContext;

public class IdWithValueTextOutputFormat<I extends WritableComparable, V extends Writable, E extends Writable>
extends TextVertexOutputFormat<I, V, E> {
    public static final String LINE_TOKENIZE_VALUE = "output.delimiter";
    public static final String LINE_TOKENIZE_VALUE_DEFAULT = "\t";
    public static final String REVERSE_ID_AND_VALUE = "reverse.id.and.value";
    public static final boolean REVERSE_ID_AND_VALUE_DEFAULT = false;

    @Override
    public TextVertexOutputFormat.TextVertexWriter createVertexWriter(TaskAttemptContext context) {
        return new IdWithValueVertexWriter();
    }

    protected class IdWithValueVertexWriter
    extends TextVertexOutputFormat.TextVertexWriterToEachLine {
        private String delimiter;
        private boolean reverseOutput;

        protected IdWithValueVertexWriter() {
            super(IdWithValueTextOutputFormat.this);
        }

        @Override
        public void initialize(TaskAttemptContext context) throws IOException, InterruptedException {
            super.initialize(context);
            this.delimiter = this.getConf().get(IdWithValueTextOutputFormat.LINE_TOKENIZE_VALUE, IdWithValueTextOutputFormat.LINE_TOKENIZE_VALUE_DEFAULT);
            this.reverseOutput = this.getConf().getBoolean(IdWithValueTextOutputFormat.REVERSE_ID_AND_VALUE, false);
        }

        @Override
        protected Text convertVertexToLine(Vertex<I, V, E> vertex) throws IOException {
            StringBuilder str = new StringBuilder();
            if (this.reverseOutput) {
                str.append(vertex.getValue().toString());
                str.append(this.delimiter);
                str.append(vertex.getId().toString());
            } else {
                str.append(vertex.getId().toString());
                str.append(this.delimiter);
                str.append(vertex.getValue().toString());
            }
            return new Text(str.toString());
        }
    }
}

